/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import com.qizx.api.CompilationException;
import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.api.XMLPullStream;
import com.qizx.util.basic.XMLUtil;

public class StreamParser {
    private XMLPullStream input;
    private int curAttrIndex;
    private int curAttrCount;
    protected QName curAttrName;
    protected String curAttrValue;

    public StreamParser(XMLPullStream xMLPullStream) {
        this.input = xMLPullStream;
        this.curAttrCount = -1;
    }

    protected void wantElemStart(String string, String string2) throws CompilationException {
        if (!this.seeElemStart(string, string2)) {
            this.syntaxError("expecting xsl:" + string2);
        }
    }

    protected void wantElemEnd(String string, String string2) throws CompilationException {
        if (!this.pickElemEnd(string, string2)) {
            this.syntaxError("expecting xsl:" + string2);
        }
    }

    protected boolean pickElemStart(String string, String string2) throws CompilationException {
        if (!this.seeElemStart(string, string2)) {
            return false;
        }
        this.moveNext();
        return true;
    }

    protected boolean seeElemStart(String string, String string2) throws CompilationException {
        this.skip();
        if (this.input.getCurrentEvent() != 3) {
            return false;
        }
        QName qName = this.input.getName();
        return qName.getNamespaceURI() == string && string2.equals(qName.getLocalPart());
    }

    protected boolean pickElemEnd(String string, String string2) throws CompilationException {
        this.skip();
        if (this.input.getCurrentEvent() != 4) {
            return false;
        }
        QName qName = this.input.getName();
        if (qName.getNamespaceURI() != string || !string2.equals(qName.getLocalPart())) {
            return false;
        }
        this.moveNext();
        return true;
    }

    protected boolean nextAttribute() {
        if (this.curAttrCount < 0) {
            this.curAttrCount = this.input.getAttributeCount();
            this.curAttrIndex = 0;
        }
        if (this.curAttrIndex >= this.curAttrCount) {
            return false;
        }
        this.curAttrName = this.input.getAttributeName(this.curAttrIndex);
        this.curAttrValue = this.input.getAttributeValue(this.curAttrIndex);
        ++this.curAttrIndex;
        return true;
    }

    protected boolean isAttr(String string, String string2) {
        return this.curAttrName.getNamespaceURI() == string && string2.equals(this.curAttrName.getLocalPart());
    }

    protected QName skip() throws CompilationException {
        block4: while (true) {
            switch (this.input.getCurrentEvent()) {
                case 6: 
                case 7: {
                    this.moveNext();
                    continue block4;
                }
                case 5: {
                    if (!XMLUtil.isXMLSpace(this.input.getText())) break block4;
                    this.moveNext();
                    continue block4;
                }
            }
            break;
        }
        return this.input.getName();
    }

    protected void skipEvent(int n) throws CompilationException {
        if (this.input.getCurrentEvent() == n) {
            this.moveNext();
        }
    }

    protected int moveNext() throws CompilationException {
        this.curAttrCount = -1;
        try {
            return this.input.moveToNextEvent();
        }
        catch (DataModelException dataModelException) {
            throw new CompilationException(dataModelException.getMessage());
        }
    }

    protected void syntaxError(String string) throws CompilationException {
        throw new CompilationException(string);
    }
}

