/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import com.qizx.util.StringPattern;

public class SoundsLikePattern
extends StringPattern {
    char[] codedPattern = new char[10];
    int cpatLen;
    char[] input;
    int ipos;
    int ilen;
    int distance;
    static final char C_END = '\u0000';

    public SoundsLikePattern(char[] cArray, int n, int n2) {
        super(cArray, n);
        this.parsePattern(cArray, n);
        this.distance = n2;
        this.fixedPrefix = new char[0];
    }

    public void parsePattern(char[] cArray, int n) {
        char c;
        this.cpatLen = 0;
        this.setInput(cArray, n);
        if (this.ilen > this.codedPattern.length) {
            this.codedPattern = new char[this.ilen];
        }
        char c2 = '?';
        while ((c = this.nextCode()) != '\u0000') {
            if (c == c2 && (c > '9' || c < '0')) continue;
            c2 = c;
            this.codedPattern[this.cpatLen++] = c;
        }
    }

    public boolean matches(char[] cArray) {
        char c;
        this.setInput(cArray, cArray.length);
        if (Math.abs(this.ilen - this.cpatLen) > 2 * this.distance) {
            return false;
        }
        char c2 = '?';
        int n = 0;
        while ((c = this.nextCode()) != '\u0000') {
            if (c == c2 && (c > '9' || c < '0')) continue;
            c2 = c;
            if (n >= this.cpatLen || c != this.codedPattern[n]) {
                return false;
            }
            ++n;
        }
        return n == this.cpatLen;
    }

    public int match(char[] cArray) {
        return this.matches(cArray) ? 0 : 1;
    }

    public String toString() {
        return "Fuzzy " + this.distance + " " + new String(this.pattern);
    }

    void setInput(char[] cArray, int n) {
        this.input = cArray;
        this.ilen = n;
        this.ipos = 0;
    }

    char nextCode() {
        char c;
        block12: while (true) {
            if (this.ipos >= this.ilen) {
                return '\u0000';
            }
            c = this.input[this.ipos++];
            switch (c) {
                case 'a': {
                    if (this.ipos < this.ilen && (this.input[this.ipos] == 'y' || this.input[this.ipos] == 'i')) {
                        ++this.ipos;
                        return 'y';
                    }
                    return 'o';
                }
                case 'o': 
                case 'u': {
                    return 'o';
                }
                case 'e': 
                case 'i': 
                case 'y': {
                    return 'y';
                }
                case 'c': {
                    if (this.ipos < this.ilen && this.input[this.ipos] == 'h') {
                        ++this.ipos;
                        return 's';
                    }
                    return 'k';
                }
                case 'd': 
                case 't': {
                    return 'd';
                }
                case 'h': {
                    continue block12;
                }
                case 'p': {
                    if (this.ipos < this.ilen && this.input[this.ipos] == 'h') {
                        ++this.ipos;
                        return 'f';
                    }
                    return 'p';
                }
                case 'q': {
                    if (this.ipos < this.ilen && this.input[this.ipos] == 'u') {
                        ++this.ipos;
                        return 'k';
                    }
                    return c;
                }
                case 'g': {
                    return 'k';
                }
                case 'm': 
                case 'n': {
                    return 'm';
                }
            }
            break;
        }
        return c;
    }
}

