/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import java.util.Arrays;
import java.util.Comparator;

public class QuickBest {
    static final int EXTRA = 4;
    protected int bestSize;
    protected int count;
    protected Item[] items;
    protected Item worst;
    protected boolean dirty;
    private static Comparator reverse = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Item)object2).compareTo(object);
        }
    };

    public void reset(int n) {
        this.bestSize = n;
        if (this.items == null || n * 5 > this.items.length) {
            this.items = new Item[5 * n];
        }
        this.count = 0;
        this.worst = null;
        this.dirty = true;
    }

    public void add(Item item) {
        if (this.worst != null && item.compareTo(this.worst) < 0) {
            return;
        }
        if (this.count >= this.items.length) {
            this.select();
            if (item.compareTo(this.worst) < 0) {
                return;
            }
        }
        this.items[this.count++] = item.replicate();
        this.dirty = true;
    }

    public Item getBest(int n) {
        if (this.dirty) {
            this.select();
        }
        return n < this.bestSize ? this.items[n] : null;
    }

    private void select() {
        Arrays.sort(this.items, 0, this.count, reverse);
        this.count = this.bestSize;
        this.worst = this.items[this.bestSize - 1];
        this.dirty = false;
    }

    public static interface Item
    extends Comparable {
        public Item replicate();
    }
}

