/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import com.qizx.util.basic.Unicode;

public class DLEditDistance {
    private int insertCost;
    private int transposeCost;
    private int substituteCost;
    private int caseDiacCost;
    private int threshold;
    private int[] costs;
    private int[] costs_1;
    private int[] costs_2;

    public DLEditDistance(int n, int n2, int n3, int n4) {
        this.insertCost = n;
        this.transposeCost = n2;
        this.substituteCost = n3;
        this.caseDiacCost = n4;
        this.threshold = Integer.MAX_VALUE;
        this.costs = new int[20];
        this.costs_1 = new int[20];
        this.costs_2 = new int[20];
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n) {
        this.threshold = n;
    }

    public int distance(char[] cArray, char[] cArray2) {
        int n;
        int n2 = cArray2.length;
        int n3 = cArray.length;
        int n4 = Math.abs(n2 - n3);
        if (n4 * this.insertCost > this.threshold) {
            return this.threshold;
        }
        if (n2 + 1 > this.costs.length) {
            this.costs = new int[n2 + 10];
            this.costs_1 = new int[n2 + 10];
            this.costs_2 = new int[n2 + 10];
        }
        for (n = 0; n <= n2; ++n) {
            this.costs_2[n] = 0;
            this.costs_1[n] = n * this.insertCost;
        }
        n = this.threshold;
        for (int i = 0; i < n3; ++i) {
            n = this.threshold;
            this.costs[0] = this.costs_1[0] + this.insertCost;
            for (int j = 0; j < n2; ++j) {
                int n5 = this.costs[j] + this.insertCost;
                int n6 = this.costs_1[j + 1] + this.insertCost;
                if (n5 < n6) {
                    n6 = n5;
                }
                int n7 = this.costs_1[j];
                char c = cArray2[j];
                if (cArray[i] != c) {
                    n7 = Unicode.collapse(cArray[i]) == Unicode.collapse(c) ? (n7 += this.caseDiacCost) : (n7 += this.substituteCost);
                    if (n7 < n6) {
                        n6 = n7;
                    }
                    if (i > 1 && j > 1 && cArray[i] == cArray2[j - 1] && cArray[i - 1] == c) {
                        n6 = Math.min(n6, this.costs_2[j - 1] + this.transposeCost);
                    }
                } else if (n7 < n6) {
                    n6 = n7;
                }
                this.costs[j + 1] = n6;
                if (n6 >= n) continue;
                n = n6;
            }
            if (n > this.threshold) {
                return this.threshold;
            }
            int[] nArray = this.costs_2;
            this.costs_2 = this.costs_1;
            this.costs_1 = this.costs;
            this.costs = nArray;
        }
        return this.costs_1[n2];
    }
}

