/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import java.util.Arrays;

public class Binary {
    byte[] value;
    private static final char[] toBase64Digit;
    private static byte[] fromBase64Digit;
    private static final int SPACE_OR_DIGIT1 = 0;
    private static final int DIGIT1 = 1;
    private static final int DIGIT2 = 2;
    private static final int DIGIT3_OR_EQUAL = 3;
    private static final int EQUAL = 4;
    private static final int DIGIT4_OR_EQUAL = 5;
    private static final int END_OR_SPACE = 6;
    private static final char[] toHexDigit;
    private static final int[] fromHexDigit;

    public Binary(byte[] byArray) {
        this.value = byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Binary)) {
            return false;
        }
        Binary binary = (Binary)object;
        return Arrays.equals(this.value, binary.value);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            n <<= 1 + this.value[i];
        }
        return n;
    }

    public int compareTo(Binary binary) {
        return this.equals(binary) ? 0 : 1;
    }

    private static void unexpected(char c) throws Exception {
        throw new Exception("unexpected base64 char #x" + Integer.toHexString(c));
    }

    private static boolean isXMLSpace(char c) {
        return c <= ' ' && (c == ' ' || c == '\n' || c == '\r' || c == '\t');
    }

    public static Binary parseBase64Binary(String string) {
        int n = string.length();
        byte[] byArray = new byte[3 * (n / 4) + 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = 0;
            if (Binary.isXMLSpace(c)) continue;
            switch (n3) {
                case 0: {
                    if (c > '\u00ff' || (by = fromBase64Digit[c]) < 0) {
                        Binary.unexpected(c);
                    }
                    n3 = 2;
                    break;
                }
                case 1: {
                    if (c > '\u00ff' || (by = fromBase64Digit[c]) < 0) {
                        Binary.unexpected(c);
                    }
                    n3 = 2;
                    break;
                }
                case 2: {
                    if (c > '\u00ff' || (by = fromBase64Digit[c]) < 0) {
                        Binary.unexpected(c);
                    }
                    n3 = 3;
                    break;
                }
                case 3: {
                    if (c == '=') {
                        n3 = 4;
                        continue block12;
                    }
                    if (c > '\u00ff' || (by = fromBase64Digit[c]) < 0) {
                        Binary.unexpected(c);
                    }
                    n3 = 5;
                    break;
                }
                case 4: {
                    if (c == '=') {
                        n3 = 6;
                        continue block12;
                    }
                    Binary.unexpected(c);
                }
                case 5: {
                    if (c == '=') {
                        n3 = 6;
                        continue block12;
                    }
                    if (c > '\u00ff' || (by = fromBase64Digit[c]) < 0) {
                        Binary.unexpected(c);
                    }
                    n3 = 0;
                    break;
                }
                case 6: {
                    if (Binary.isXMLSpace(c)) continue block12;
                    Binary.unexpected(c);
                }
                default: {
                    throw new Exception("unknown state " + n3);
                }
            }
            n4 <<= 6;
            n4 |= by;
            if ((n5 += 6) < 8) continue;
            byArray[n2++] = (byte)(n4 >> (n5 -= 8) & 0xFF);
        }
        switch (n3) {
            case 0: 
            case 1: 
            case 6: {
                break;
            }
            default: {
                throw new Exception("truncated base64 string");
            }
        }
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return new Binary(byArray);
    }

    public String toBase64String() {
        byte[] byArray = this.value;
        int n = (byArray.length + 2) / 3 * 4;
        char[] cArray = new char[n + (n + 75) / 76];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < byArray.length; i += 3) {
            boolean bl = false;
            boolean bl2 = false;
            int n4 = byArray[i] & 0xFF;
            n4 <<= 8;
            if (i + 1 < byArray.length) {
                n4 |= byArray[i + 1] & 0xFF;
                bl2 = true;
            }
            n4 <<= 8;
            if (i + 2 < byArray.length) {
                n4 |= byArray[i + 2] & 0xFF;
                bl = true;
            }
            cArray[n2 + 3] = toBase64Digit[bl ? n4 & 0x3F : 64];
            cArray[n2 + 2] = toBase64Digit[bl2 ? (n4 >>>= 6) & 0x3F : 64];
            cArray[n2 + 1] = toBase64Digit[(n4 >>>= 6) & 0x3F];
            cArray[n2] = toBase64Digit[(n4 >>>= 6) & 0x3F];
            n2 += 4;
            if ((n3 += 4) != 76) continue;
            cArray[n2++] = 10;
            n3 = 0;
        }
        return new String(cArray, 0, n2);
    }

    public static Binary parseHexBinary(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw new Exception("odd hexBinary length");
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            int n3;
            int n4;
            char c = string.charAt(i);
            char c2 = string.charAt(i + 1);
            if (c < '0' || c > 'f' || (n4 = fromHexDigit[c - 48]) < 0) {
                throw new Exception("invalid hex char #x" + Integer.toHexString(c));
            }
            if (c2 < '0' || c2 > 'f' || (n3 = fromHexDigit[c2 - 48]) < 0) {
                throw new Exception("invalid hex char #x" + Integer.toHexString(c2));
            }
            byArray[n2++] = (byte)((n4 & 0xF) << 4 | n3 & 0xF);
        }
        return new Binary(byArray);
    }

    public String toHexString() {
        char[] cArray = new char[2 * this.value.length];
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            byte by = this.value[i];
            cArray[n++] = toHexDigit[by >>> 4 & 0xF];
            cArray[n++] = toHexDigit[by & 0xF];
        }
        return new String(cArray);
    }

    static {
        int n;
        toBase64Digit = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        fromBase64Digit = new byte[256];
        for (n = 0; n < 256; ++n) {
            Binary.fromBase64Digit[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            Binary.fromBase64Digit[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            Binary.fromBase64Digit[n] = (byte)(26 + n - 97);
        }
        for (n = 48; n <= 57; ++n) {
            Binary.fromBase64Digit[n] = (byte)(52 + n - 48);
        }
        Binary.fromBase64Digit[43] = 62;
        Binary.fromBase64Digit[47] = 63;
        toHexDigit = "0123456789ABCDEF".toCharArray();
        fromHexDigit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    }

    public static class Exception
    extends IllegalArgumentException {
        Exception(String string) {
            super(string);
        }
    }
}

