/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.restclient;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.apps.util.Property;
import com.qizx.restclient.ClientConnection;
import com.qizx.xdm.IQName;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTConnection
extends ClientConnection {
    public static final QName NAME = IQName.get("name");
    public static final QName TYPE = IQName.get("type");
    public static final QName PROPERTY = IQName.get("property");
    protected String libName;

    public RESTConnection(String string) throws MalformedURLException {
        this.setBaseURL(string);
    }

    protected void startGet(String string, String string2) {
        super.startGet();
        this.curGet.setParameter("op", string);
        if (string2 != null) {
            this.curGet.setParameter("path", string2);
        }
        if (this.libName != null) {
            this.curGet.setParameter("library", this.libName);
        }
    }

    protected void startPost(String string, String string2) {
        super.startPost();
        this.curPost.setParameter("op", string);
        if (string2 != null) {
            this.curPost.setParameter("path", string2);
        }
        if (this.libName != null) {
            this.curPost.setParameter("library", this.libName);
        }
    }

    public void setLibraryName(String string) {
        this.libName = string;
    }

    public List<Property> nextPropSet() throws DataModelException {
        if (!this.nextResultNode()) {
            return null;
        }
        return this.getProperties(this.curNode);
    }

    public Node nextItem() throws DataModelException {
        if (!this.nextResultNode()) {
            return null;
        }
        return this.curNode;
    }

    private boolean nextResultNode() throws DataModelException {
        if (this.curNode == null) {
            this.getNode();
            if (this.curRoot == null) {
                return false;
            }
            this.curNode = this.curRoot.getFirstChild();
            if (this.curNode != null) {
                this.curNode = this.curNode.getFirstChild();
            }
        } else {
            this.curNode = this.curNode.getNextSibling();
        }
        return this.curNode != null;
    }

    public void login() throws IOException {
        this.startGet("server", null);
        this.curGet.setParameter("command", "status");
        this.send();
        this.gotError();
        String string = this.getNextLine();
        if (!"online".equals(string) && !"offline".equals(string)) {
            throw new IOException("invalid response from REST server: " + string);
        }
    }

    public void get(String string) throws IOException {
        this.get(string, null);
    }

    public void get(String string, String string2) throws IOException {
        this.startGet("get", string);
        if (string2 != null) {
            this.curGet.setParameter("options", string2);
        }
        this.send();
    }

    public void eval(String string, String string2) throws IOException {
        this.startPost("eval", null);
        this.curPost.setParameter("format", string2);
        this.curPost.setParameter("query", string);
        this.send();
    }

    public void evalAsItems(String string, int n, int n2) throws IOException {
        this.eval(string, "items", null, -1, n, n2);
    }

    public void eval(String string, String string2, String string3, int n, int n2, int n3) throws IOException {
        this.startPost("eval", null);
        this.curPost.setParameter("query", string);
        this.curPost.setParameter("format", string2);
        if (string3 != null) {
            this.curPost.setParameter("encoding", string3);
        }
        if (n2 > 0) {
            this.curPost.setParameter("count", Integer.toString(n2));
        }
        this.curPost.setParameter("first", Integer.toString(n3));
        if (n > 0) {
            this.curPost.setParameter("maxtime", Integer.toString(n));
        }
        this.send();
    }

    public void startPut() {
        this.startPost("put", null);
        this.paramRank = 0;
    }

    public void startPutNonXML() {
        this.startPost("putnonxml", null);
        this.paramRank = 0;
    }

    public void addDocument(String string, File file, String string2) throws IOException {
        if (this.curPost == null) {
            throw new IOException("no startPut");
        }
        String string3 = this.rankedParam("path");
        this.curPost.addParameter(string3, string);
        this.curPost.addParameter(this.rankedParam("data"), file, string2);
        this.paramRank = Math.max(2, this.paramRank + 1);
    }

    public void addDocument(String string, String string2) throws IOException {
        if (this.curPost == null) {
            throw new IOException("no startPut");
        }
        this.curPost.addParameter(this.rankedParam("path"), string);
        this.curPost.addParameter(this.rankedParam("data"), string2);
        this.paramRank = Math.max(2, this.paramRank + 1);
    }

    public String createCollection(String string, boolean bl) throws IOException {
        this.startPost("mkcol", string);
        this.curPost.setParameter("parents", bl);
        this.send();
        return this.getNextLine();
    }

    public String move(String string, String string2) throws IOException {
        this.startPost("move", null);
        this.curPost.setParameter("src", string);
        this.curPost.setParameter("dst", string2);
        this.send();
        return this.getNextLine();
    }

    public String copy(String string, String string2) throws IOException {
        this.startPost("copy", null);
        this.curPost.setParameter("src", string);
        this.curPost.setParameter("dst", string2);
        this.send();
        return this.getNextLine();
    }

    public boolean delete(String string) throws IOException {
        this.startPost("delete", string);
        this.send();
        String string2 = this.getNextLine();
        return string2 != null && string2.length() > 0;
    }

    public void getProp(String string, int n, String[] stringArray) throws IOException {
        this.startGet("getprop", string);
        this.curGet.setParameter("depth", Integer.toString(n));
        if (stringArray != null) {
            this.curGet.setParameter("properties", this.nameList(stringArray));
        }
        this.send();
    }

    public void startSetProp(String string, String string2, String string3, String string4) {
        this.startPost("setprop", string);
        this.paramRank = 0;
        this.addProperty(string2, string3, string4);
    }

    public void addProperty(String string, String string2, String string3) {
        this.curPost.addParameter(this.rankedParam("name"), string);
        if (string2 != null) {
            this.curPost.addParameter(this.rankedParam("type"), string2);
        }
        if (string3 != null) {
            this.curPost.addParameter(this.rankedParam("value"), string3);
        }
        ++this.paramRank;
    }

    public void queryProp(String string, String string2, String[] stringArray) throws IOException {
        this.startGet("queryprop", string);
        if (string2 != null) {
            this.curGet.setParameter("query", string2);
        }
        if (stringArray != null) {
            this.curGet.setParameter("properties", this.nameList(stringArray));
        }
        this.send();
    }

    public List<Property> info() throws DataModelException, IOException {
        this.startGet("info", null);
        this.send();
        this.getNode();
        if (this.curRoot == null) {
            return null;
        }
        this.curNode = this.curRoot.getFirstChild();
        return this.getProperties(this.curNode);
    }

    private List<Property> getProperties(Node node) throws DataModelException {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeName() == null) continue;
            Node node3 = node2.getAttribute(NAME);
            if (node3 == null || node2.getNodeName() != PROPERTY) {
                throw new DataModelException("improper property node " + node2);
            }
            Property property = new Property();
            property.name = node3.getStringValue();
            Node node4 = node2.getAttribute(TYPE);
            property.type = node4 == null ? "string" : node4.getStringValue();
            Node node5 = node2.getFirstChild();
            if (property.type.endsWith("()")) {
                property.nodeValue = node5;
            } else {
                property.value = node5.getStringValue();
            }
            arrayList.add(property);
        }
        return arrayList;
    }

    public String serverControl(String string) throws IOException {
        this.startPost("server", null);
        this.curPost.setParameter("command", string);
        this.send();
        return this.getNextLine();
    }

    public String[] listLibraries() throws IOException {
        this.startGet("listlib", null);
        this.send();
        String string = this.getResultString();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void createLibrary(String string) throws IOException {
        this.startPost("mklib", null);
        this.curPost.setParameter("name", string);
        this.send();
    }

    public void deleteLibrary(String string) throws IOException {
        this.startPost("dellib", null);
        this.curPost.setParameter("name", string);
        this.send();
    }

    public void getIndexing() throws IOException {
        this.startGet("getindexing", null);
        this.send();
    }

    public void setIndexing(File file) throws IOException {
        this.startPost("setindexing", null);
        this.curPost.setParameter("indexing", file, null);
        this.send();
    }

    public void setIndexing(String string) throws IOException {
        this.startPost("setindexing", null);
        this.curPost.setParameter("indexing", string);
        this.send();
    }

    public String reindex() throws IOException {
        this.startPost("reindex", null);
        this.send();
        return this.getNextLine();
    }

    public String optimize() throws IOException {
        this.startPost("optimize", null);
        this.send();
        return this.getNextLine();
    }

    public String backup(String string) throws IOException {
        this.startPost("backup", string);
        this.send();
        return this.getNextLine();
    }

    public double getProgress(String string) throws IOException {
        this.startGet("progress", null);
        this.curGet.setParameter("id", string);
        this.send();
        String string2 = this.getNextLine();
        string2 = this.getNextLine();
        return string2 == null ? Double.NaN : Double.parseDouble(string2);
    }

    public void getAcl(String string, boolean bl) throws IOException {
        this.startGet("getacl", string);
        this.curGet.setParameter("inherited", Boolean.toString(bl));
        this.send();
    }

    public void setAcl(String string) throws IOException {
        this.startPost("setacl", null);
        this.curPost.setParameter("acl", string);
        this.send();
    }
}

