/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.fulltext;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Expression;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.XMLPullStream;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.FullTextPullStream;
import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.queries.FullText;
import com.qizx.queries.SimpleFullText;
import com.qizx.queries.iterators.OrIterator;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.queries.iterators.TokenStream;
import com.qizx.util.basic.Check;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.NodePullStream;
import com.qizx.xdm.XMLPullStreamBase;
import com.qizx.xquery.DynamicContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExpressionImpl;
import com.qizx.xquery.ext.FT_Contains;

public class FullTextHighlighter
extends XMLPullStreamBase
implements FullTextPullStream {
    private XMLPullStream source;
    private FullTextFactory ftFactory;
    private String language;
    protected FullText.Any allTerms;
    private PostingIterator termsIter;
    private TokenStream tokenStream;
    private FONIDataModel dataModel;
    private String currentText;
    private TextPiece currentPiece;
    private TextPiece textPiece;
    private TextPiece termPiece;
    private int lastStart;
    private int lastPosting;
    private int curDocId;

    public FullTextHighlighter(Expression expression) throws EvaluationException {
        Check.implementation(expression, ExpressionImpl.class, Expression.class);
        ExpressionImpl expressionImpl = (ExpressionImpl)expression;
        com.qizx.xquery.op.Expression expression2 = expressionImpl.getExpr();
        DynamicContext dynamicContext = expressionImpl.getDynCtx();
        EvalContext evalContext = new EvalContext(dynamicContext);
        this.init(FT_Contains.compileQueryArgument(expression2, null, evalContext), dynamicContext.getFulltextFactory());
    }

    public FullTextHighlighter(String string, FullTextFactory fullTextFactory, String string2) throws DataModelException {
        Check.nonNull(string, "simpleSyntaxQuery");
        Check.nonNull(fullTextFactory, "fulltextFactory");
        this.ftFactory = fullTextFactory;
        this.language = string2;
        FullText.MatchOptions matchOptions = new FullText.MatchOptions();
        matchOptions.language = string2;
        SimpleFullText simpleFullText = new SimpleFullText(fullTextFactory.getTokenizer(string2));
        this.init(simpleFullText.parseQuery(string, matchOptions), fullTextFactory);
    }

    public FullTextHighlighter(String[] stringArray, FullTextFactory fullTextFactory, String string) {
        Check.nonNull(stringArray, "String[] words");
        Check.nonNull(fullTextFactory, "fulltextFactory");
        this.ftFactory = fullTextFactory;
        this.language = string;
        this.allTerms = new FullText.Any();
        this.allTerms.setPosFilters(new FullText.PosFilters(true));
        FullText.MatchOptions matchOptions = new FullText.MatchOptions();
        matchOptions.language = string;
        this.allTerms.setMatchOptions(matchOptions);
        for (int i = 0; i < stringArray.length; ++i) {
            this.allTerms.addChild(new FullText.SimpleWord(stringArray[i].toCharArray()));
        }
    }

    public FullTextHighlighter(FullText.Selection selection, FullTextFactory fullTextFactory) {
        Check.nonNull(selection, "query");
        Check.nonNull(fullTextFactory, "fulltextFactory");
        this.init(selection, fullTextFactory);
    }

    private void init(FullText.Selection selection, FullTextFactory fullTextFactory) {
        this.ftFactory = fullTextFactory;
        this.language = selection.getMatchOptions().language;
        this.allTerms = new FullText.Any();
        this.allTerms.setPosFilters(new FullText.PosFilters(true));
        this.allTerms.setMatchOptions(selection.getMatchOptions());
        this.collectBasicTerms(selection, 1.0f, this.allTerms);
    }

    private void collectBasicTerms(FullText.Selection selection, float f, FullText.Any any) {
        if (selection instanceof FullText.SimpleWord || selection instanceof FullText.Wildcard) {
            try {
                selection.setWeight(f);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
            any.addChild(selection);
        } else if (selection instanceof FullText.SelectionList) {
            FullText.SelectionList selectionList = (FullText.SelectionList)selection;
            float f2 = selection instanceof FullText.Any ? 0.5f * f : f;
            int n = selectionList.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.collectBasicTerms(selectionList.getChild(i), f2, any);
            }
        } else if (selection instanceof FullText.MildNot) {
            this.collectBasicTerms(((FullText.MildNot)selection).what, f, any);
        }
    }

    public void start(Node node) throws DataModelException {
        this.curEvent = 0;
        this.termsIter = null;
        this.start(new NodePullStream(node));
    }

    public void start(XMLPullStream xMLPullStream) {
        this.source = xMLPullStream;
        this.tokenStream = new TokenStream(this.ftFactory, this.language);
        this.termsIter = this.allTerms.realize(this.tokenStream);
        this.curEvent = 0;
    }

    public int getQueryTermCount() {
        return this.allTerms.getChildCount();
    }

    public String[] getQueryTerms() {
        int n = this.getQueryTermCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.allTerms.getChild(i).asString();
        }
        return stringArray;
    }

    public int moveToNextEvent() throws DataModelException {
        try {
            if (this.textPiece != null) {
                this.currentPiece = this.textPiece;
                this.textPiece = null;
                return this.setEvent(this.currentPiece.eventType);
            }
            if (this.termPiece != null) {
                this.currentPiece = this.termPiece;
                this.termPiece = null;
                this.nextTerm();
                return this.setEvent(this.currentPiece.eventType);
            }
            this.lastPosting = -1;
            this.curEvent = this.source.moveToNextEvent();
            switch (this.curEvent) {
                case 5: {
                    this.currentText = this.source.getText();
                    this.startTokenStream();
                    if (!this.nextTerm()) break;
                    return this.moveToNextEvent();
                }
                case 6: 
                case 7: {
                    this.currentText = this.source.getText();
                    break;
                }
                default: {
                    this.currentText = null;
                    this.currentPiece = null;
                    this.termPiece = null;
                }
            }
            return this.curEvent;
        }
        catch (EvaluationException evaluationException) {
            throw new DataModelException(evaluationException.getErrorCode(), evaluationException.getMessage());
        }
    }

    private void startTokenStream() {
        this.tokenStream.reset();
        this.tokenStream.parseText(this.currentText, null);
        this.termsIter.resetDoc();
        this.termsIter.resetToNode(0);
        this.lastStart = 0;
        this.termPiece = null;
        this.textPiece = null;
        this.currentPiece = null;
    }

    public int getTermPosition() {
        return this.currentPiece == null ? -1 : this.currentPiece.termPos;
    }

    public int getWordCount() {
        if (this.currentPiece != null) {
            return this.currentPiece.wordCount;
        }
        return this.currentText == null ? 0 : this.tokenStream.countTokens(this.currentText);
    }

    private boolean nextTerm() throws DataModelException, EvaluationException {
        this.curEvent = 5;
        if (this.termsIter.nextNode()) {
            int n = this.lastPosting;
            this.lastPosting = this.termsIter.getNodeId();
            int n2 = this.tokenStream.getTokenStart(this.lastPosting);
            int n3 = this.tokenStream.getTokenLength(this.lastPosting);
            if (n2 > this.lastStart) {
                this.textPiece = new TextPiece(5, this.lastStart, n2 - this.lastStart, -1, this.lastPosting - n - 1);
            }
            int n4 = this.termsIter instanceof OrIterator ? ((OrIterator)this.termsIter).getRankOfCurrent() : 0;
            this.termPiece = new TextPiece(8, n2, n3, n4, 1);
            this.lastStart = n2 + n3;
            return true;
        }
        if (this.lastStart > 0) {
            this.textPiece = new TextPiece(5, this.lastStart, this.currentText.length() - this.lastStart, -1, this.tokenStream.getTokenCount() - this.lastPosting - 1);
        }
        return false;
    }

    protected void lazyGetAttrs() {
        this.attrCount = 0;
        if (this.source != null) {
            int n = this.source.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                this.addAttribute(this.source.getAttributeName(i), this.source.getAttributeValue(i));
            }
        }
    }

    protected void lazyGetNS() {
        if (this.source != null) {
            this.nsCount = 0;
            int n = this.source.getNamespaceCount();
            for (int i = 0; i < n; ++i) {
                this.addNamespace(this.source.getNamespacePrefix(i), this.source.getNamespaceURI(i));
            }
        }
    }

    public QName getName() {
        return this.source.getName();
    }

    public String getText() {
        if (this.currentPiece != null) {
            return this.currentText.substring(this.currentPiece.start, this.currentPiece.start + this.currentPiece.length);
        }
        return this.currentText;
    }

    public int getTextLength() {
        return this.currentPiece != null ? this.currentPiece.length : this.currentText.length();
    }

    public String getTarget() {
        return this.source.getTarget();
    }

    public String extractFirstWords(String string, int n) {
        int n2;
        TextTokenizer textTokenizer = this.tokenStream.getTokenizer();
        textTokenizer.start(string);
        while ((n2 = textTokenizer.nextToken()) != 0 && (n2 != 1 || --n > 0)) {
        }
        return string.substring(0, textTokenizer.getTokenOffset() + textTokenizer.getTokenLength());
    }

    public String extractLastWords(String string, int n) {
        int n2;
        TextTokenizer textTokenizer = this.tokenStream.getTokenizer();
        n = this.tokenStream.countTokens(string) - n;
        textTokenizer.start(string);
        while ((n2 = textTokenizer.nextToken()) != 0 && (n2 != 1 || --n >= 0)) {
        }
        return string.substring(textTokenizer.getTokenOffset());
    }

    public Node getCurrentNode() {
        if (this.source != null) {
            return this.source.getCurrentNode();
        }
        return null;
    }

    static class TextPiece {
        int eventType;
        int start;
        int length;
        int wordCount;
        int termPos;

        public TextPiece(int n, int n2, int n3, int n4, int n5) {
            this.eventType = n;
            this.start = n2;
            this.length = n3;
            this.termPos = n4;
            this.wordCount = n5;
        }
    }
}

