/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.XMLPullStream;
import com.qizx.api.XMLPushStream;
import com.qizx.api.util.PushStreamToSAX;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.IDocument;

public class PullStreamConverter {
    public static int convertTree(XMLPullStream xMLPullStream, XMLPushStream xMLPushStream) throws DataModelException {
        int n = xMLPullStream.getCurrentEvent();
        if (n == 0) {
            n = xMLPullStream.moveToNextEvent();
        }
        switch (n) {
            case 1: {
                PullStreamConverter.documentStart(xMLPullStream, xMLPushStream);
                n = xMLPullStream.moveToNextEvent();
                while (n != 2 && n != -1) {
                    PullStreamConverter.convertTree(xMLPullStream, xMLPushStream);
                }
                if (n != 2) break;
                xMLPushStream.putDocumentEnd();
                break;
            }
            case 3: {
                PullStreamConverter.elementStart(xMLPullStream, xMLPushStream);
                n = xMLPullStream.moveToNextEvent();
                while (n != 4 && n != -1) {
                    n = PullStreamConverter.convertTree(xMLPullStream, xMLPushStream);
                }
                if (n != 4) break;
                xMLPushStream.putElementEnd(xMLPullStream.getName());
                break;
            }
            case 5: {
                xMLPushStream.putText(xMLPullStream.getText());
                break;
            }
            case 7: {
                xMLPushStream.putProcessingInstruction(xMLPullStream.getTarget(), xMLPullStream.getText());
                break;
            }
            case 6: {
                xMLPushStream.putComment(xMLPullStream.getText());
                break;
            }
            case -1: {
                return n;
            }
        }
        n = xMLPullStream.moveToNextEvent();
        return n;
    }

    public static Node buildNode(XMLPullStream xMLPullStream) throws DataModelException {
        int n = xMLPullStream.getCurrentEvent();
        switch (n) {
            case 1: {
                IDocument iDocument = new IDocument();
                PullStreamConverter.convertTree(xMLPullStream, new PushStreamToSAX(iDocument));
                return new FONIDataModel(iDocument).getDocumentNode();
            }
            case 3: {
                IDocument iDocument = new IDocument();
                PullStreamConverter.convertTree(xMLPullStream, new PushStreamToSAX(iDocument));
                return new FONIDataModel(iDocument).getDocumentNode();
            }
            case 5: {
                CorePushBuilder corePushBuilder = new CorePushBuilder(".");
                corePushBuilder.putText(xMLPullStream.getText());
                return corePushBuilder.harvest();
            }
            case 7: {
                CorePushBuilder corePushBuilder = new CorePushBuilder(".");
                corePushBuilder.putProcessingInstruction(xMLPullStream.getTarget(), xMLPullStream.getText());
                return corePushBuilder.harvest();
            }
            case 6: {
                CorePushBuilder corePushBuilder = new CorePushBuilder(".");
                corePushBuilder.putComment(xMLPullStream.getText());
                return corePushBuilder.harvest();
            }
        }
        return null;
    }

    private PullStreamConverter() {
    }

    private static void documentStart(XMLPullStream xMLPullStream, XMLPushStream xMLPushStream) throws DataModelException {
        xMLPushStream.putDocumentStart();
        String string = xMLPullStream.getDTDName();
        if (string != null) {
            xMLPushStream.putDTD(string, xMLPullStream.getDTDPublicId(), xMLPullStream.getDTDSystemId(), xMLPullStream.getInternalSubset());
        }
    }

    private static void elementStart(XMLPullStream xMLPullStream, XMLPushStream xMLPushStream) throws DataModelException {
        int n;
        xMLPushStream.putElementStart(xMLPullStream.getName());
        int n2 = xMLPullStream.getNamespaceCount();
        for (n = 0; n < n2; ++n) {
            xMLPushStream.putNamespace(xMLPullStream.getNamespacePrefix(n), xMLPullStream.getNamespaceURI(n));
        }
        n2 = xMLPullStream.getAttributeCount();
        for (n = 0; n < n2; ++n) {
            xMLPushStream.putAttribute(xMLPullStream.getAttributeName(n), xMLPullStream.getAttributeValue(n), null);
        }
    }
}

