/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.util.PushStreamToSAX;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class NodeXMLReader
implements XMLReader {
    static final String FEATURE_NS = "http://xml.org/sax/features/namespaces";
    static final String FEATURE_NSPREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    static final String PROPERTY_LEXICAL = "http://xml.org/sax/properties/lexical-handler";
    private PushStreamToSAX saxout = new PushStreamToSAX();
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private Node rootNode;

    public NodeXMLReader(Node node) {
        this.rootNode = node;
    }

    private void exec() throws SAXException {
        try {
            this.saxout.setNsPrefixes(true);
            this.saxout.reset();
            this.saxout.putNodeCopy(this.rootNode, 0);
            this.saxout.flush();
        }
        catch (DataModelException dataModelException) {
            throw new SAXException("traversal error", dataModelException);
        }
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.exec();
    }

    public void parse(String string) throws IOException, SAXException {
        this.exec();
    }

    public ContentHandler getContentHandler() {
        return this.saxout.getContentHandler();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.saxout.setContentHandler(contentHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.saxout.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxout.setErrorHandler(errorHandler);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(FEATURE_NS)) {
            return true;
        }
        if (string.equals(FEATURE_NSPREFIXES)) {
            return this.saxout.getNsPrefixes();
        }
        throw new SAXNotSupportedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(FEATURE_NS)) {
            if (!bl) {
                throw new SAXNotSupportedException("feature " + string + " is mandatory");
            }
        } else if (string.equals(FEATURE_NSPREFIXES)) {
            this.saxout.setNsPrefixes(bl);
        } else {
            throw new SAXNotSupportedException(string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(PROPERTY_LEXICAL)) {
            return this.saxout.getLexicalHandler();
        }
        throw new SAXNotSupportedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(PROPERTY_LEXICAL)) {
            this.saxout.setLexicalHandler((LexicalHandler)object);
        }
        throw new SAXNotSupportedException(string);
    }
}

