/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.DataModelException;
import com.qizx.api.ItemFactory;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.XMLPushStream;
import com.qizx.api.util.PushNodeBuilder;
import com.qizx.xdm.CoreDataModel;
import com.qizx.xdm.IQName;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class DOMToPushStream {
    private final ItemFactory itemFactory;
    private XMLPushStream output;
    private HashSet prefixes = new HashSet();

    public DOMToPushStream(ItemFactory itemFactory, XMLPushStream xMLPushStream) {
        this.itemFactory = itemFactory;
        this.output = xMLPushStream;
    }

    public XMLPushStream getOutput() {
        return this.output;
    }

    public void setOutput(XMLPushStream xMLPushStream) {
        this.output = xMLPushStream;
    }

    public void putDocument(Document document) throws DataModelException {
        this.output.putDocumentStart();
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            this.output.putDTD(documentType.getName(), documentType.getPublicId(), documentType.getSystemId(), documentType.getInternalSubset());
        }
        this.putElement(document.getDocumentElement());
        this.output.putDocumentEnd();
    }

    public static Node convertNode(org.w3c.dom.Node node) throws DataModelException {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                return new CoreDataModel(null).newTextNode(node.getNodeValue());
            }
            case 8: {
                return new CoreDataModel(null).newCommentNode(node.getNodeValue());
            }
            case 7: {
                return new CoreDataModel(null).newPINode(node.getNodeName(), node.getNodeValue());
            }
            case 1: {
                PushNodeBuilder pushNodeBuilder = new PushNodeBuilder();
                new DOMToPushStream(null, pushNodeBuilder).putElement((Element)node);
                return pushNodeBuilder.reap();
            }
            case 9: {
                PushNodeBuilder pushNodeBuilder = new PushNodeBuilder();
                new DOMToPushStream(null, pushNodeBuilder).putDocument((Document)node);
                return pushNodeBuilder.reap();
            }
        }
        throw new DataModelException("unexpected " + DOMToPushStream.nodeTypeName(node) + " node");
    }

    public void putElement(Element element) throws DataModelException {
        QName qName = this.getQName(element);
        this.output.putElementStart(qName);
        this.prefixes.clear();
        this.putNamespace(element, false);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node node = namedNodeMap.item(i);
            String string = node.getNodeName();
            if (string == null || string.startsWith("xmlns")) continue;
            this.output.putAttribute(this.getQName(node), node.getNodeValue(), null);
            this.putNamespace(node, true);
        }
        block7: for (org.w3c.dom.Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    this.output.putText(node.getNodeValue());
                    continue block7;
                }
                case 8: {
                    this.output.putComment(node.getNodeValue());
                    continue block7;
                }
                case 7: {
                    this.output.putProcessingInstruction(node.getNodeName(), node.getNodeValue());
                    continue block7;
                }
                case 1: {
                    this.putElement((Element)node);
                    continue block7;
                }
                default: {
                    throw new DataModelException("unexpected " + DOMToPushStream.nodeTypeName(node) + " node");
                }
            }
        }
        this.output.putElementEnd(qName);
    }

    private QName getQName(org.w3c.dom.Node node) throws DataModelException {
        String string = null;
        String string2 = node.getLocalName();
        if (string2 == null) {
            string2 = node.getNodeName();
            System.err.println("the name of " + DOMToPushStream.nodeTypeName(node) + " node '" + string2 + "' has no local part");
        } else {
            string = node.getNamespaceURI();
        }
        if (string2 == null) {
            throw new DataModelException("the name of " + DOMToPushStream.nodeTypeName(node) + " node is null");
        }
        if (string == null) {
            return this.itemFactory != null ? this.itemFactory.getQName(string2) : IQName.get(string2);
        }
        return this.itemFactory != null ? this.itemFactory.getQName(string2, string) : IQName.get(string, string2);
    }

    private void putNamespace(org.w3c.dom.Node node, boolean bl) throws DataModelException {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        if ((string2 == null || string2.length() == 0) && bl) {
            return;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!this.prefixes.contains(string)) {
            this.prefixes.add(string);
            this.output.putNamespace(string, string2);
        }
    }

    private static String nodeTypeName(org.w3c.dom.Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 2: {
                return "ATTRIBUTE";
            }
            case 4: {
                return "CDATA_SECTION";
            }
            case 8: {
                return "COMMENT";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT";
            }
            case 9: {
                return "DOCUMENT";
            }
            case 10: {
                return "DOCUMENT_TYPE";
            }
            case 1: {
                return "ELEMENT";
            }
            case 6: {
                return "ENTITY";
            }
            case 5: {
                return "ENTITY_REFERENCE";
            }
            case 12: {
                return "NOTATION";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION";
            }
            case 3: {
                return "TEXT";
            }
        }
        return Integer.toString(s);
    }

    private void dump(org.w3c.dom.Node node) {
        switch (node.getNodeType()) {
            case 9: {
                break;
            }
            case 1: {
                System.err.println("ELEM " + node.getLocalName() + " nsuri=" + node.getNamespaceURI() + " qname=" + node.getNodeName() + " prefix=" + node.getPrefix());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    org.w3c.dom.Node node2 = namedNodeMap.item(i);
                    System.err.println("  ATTR " + node2.getLocalName() + " nsuri=" + node2.getNamespaceURI() + " qname=" + node2.getNodeName() + " prefix=" + node2.getPrefix());
                }
                for (org.w3c.dom.Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    this.dump(node3);
                }
                System.err.println("END");
                break;
            }
            case 3: {
                System.err.println("TEXT |" + node.getNodeValue() + "|");
                break;
            }
            case 7: {
                System.err.println("PI " + node.getNodeName() + " |" + node.getNodeValue() + "| ");
                break;
            }
            case 8: {
                System.err.println("COMMENT |" + node.getNodeValue() + "|");
            }
        }
    }
}

