/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.apps.studio.gui.TreePort;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.BasicNode;
import javax.swing.JPopupMenu;

public class XmlNode
extends TreePort.ColoredNode {
    public static final int DOCU = 1;
    public static final int TAG = 2;
    public static final int ATTR = 3;
    public static final int TEXT_STYLE = 0;
    public static final int COMMENT_STYLE = 4;
    public static final int PI_STYLE = 5;
    private static final int MAX_LINE = 200;
    private static final int MAX_CHILDREN = 10000;
    protected static NamespaceContext namespaces = new NamespaceContext();
    protected Node node;
    private boolean leaf;
    private boolean endTag;
    private String stringRep;
    protected TreePort tree;

    public XmlNode(Node node, TreePort treePort) {
        this(node, treePort, false);
    }

    public XmlNode(Node node, TreePort treePort, boolean bl) {
        this.node = node;
        this.tree = treePort;
        this.endTag = bl;
    }

    public String toString() {
        try {
            this.prepare();
            if ("<html>".equals(this.stringRep)) {
                this.stringRep = "<html>&lt;html>";
            }
        }
        catch (Exception exception) {
            this.showException(exception);
        }
        return this.stringRep;
    }

    public boolean isLeaf() {
        try {
            this.prepare();
        }
        catch (Exception exception) {
            this.showException(exception);
            return true;
        }
        return this.leaf || this.endTag;
    }

    private void showException(Exception exception) {
        this.stringRep = ">>> " + exception.getMessage() + " <<<";
        this.sections = null;
    }

    protected void procreate() {
        if (!this.isLeaf()) {
            try {
                Node node = this.node.getFirstChild();
                if (this.node.getNodeName() != null && node.getNodeNature() == 7) {
                    node = node.getNextSibling();
                }
                int n = 0;
                while (node != null) {
                    if (!this.isWhiteSpace(node)) {
                        this.add(new XmlNode(node, this.tree));
                    }
                    if (++n > 10000) {
                        this.add(this.truncationNode());
                        break;
                    }
                    node = node.getNextSibling();
                }
                if (this.node.getNodeNature() == 2) {
                    this.add(new XmlNode(this.node, this.tree, true));
                }
            }
            catch (DataModelException dataModelException) {
                this.add(new TreePort.ErrorNode(dataModelException));
            }
        }
    }

    protected JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new TreePort.NodeAction(this.tree.isExpanded(this) ? "Collapse all" : "Expand all", this, "cmdExpandAll", this));
        return jPopupMenu;
    }

    private void prepare() throws DataModelException {
        if (this.stringRep != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.leaf = true;
        switch (this.node.getNodeNature()) {
            case 1: {
                this.leaf = false;
                stringBuilder.append("<?xml version='1.0'?>");
                this.endSection(stringBuilder, 1);
                break;
            }
            case 2: {
                Object object;
                int n;
                int n2;
                stringBuilder.append(this.endTag ? "</" : "<");
                this.putName(this.node, stringBuilder);
                if (this.endTag) {
                    this.closeTag(stringBuilder);
                    break;
                }
                this.endSection(stringBuilder, 2);
                Node[] nodeArray = this.node.getAttributes();
                if (nodeArray != null) {
                    for (n2 = 0; n2 < nodeArray.length; ++n2) {
                        stringBuilder.append(' ');
                        if (nodeArray[n2] == null) {
                            System.err.println("OOPS attr " + n2);
                            continue;
                        }
                        this.putName(nodeArray[n2], stringBuilder);
                        stringBuilder.append("=\"");
                        stringBuilder.append(nodeArray[n2].getStringValue());
                        stringBuilder.append('\"');
                        this.endSection(stringBuilder, 3);
                    }
                }
                namespaces.clear();
                n2 = ((BasicNode)this.node).addNamespacesTo(namespaces);
                if (n2 > 0) {
                    for (n = 0; n < n2; ++n) {
                        String string = namespaces.getLocalNamespaceURI(n);
                        object = namespaces.getLocalPrefix(n);
                        stringBuilder.append(" xmlns");
                        if (object != null && ((String)object).length() > 0) {
                            stringBuilder.append(':');
                            stringBuilder.append((String)object);
                        }
                        stringBuilder.append("=\"");
                        stringBuilder.append(string);
                        stringBuilder.append('\"');
                        this.endSection(stringBuilder, 3);
                    }
                }
                n = 1;
                boolean bl = false;
                for (object = this.node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    n = 0;
                    if (object.getNodeNature() != 7) {
                        this.leaf = false;
                        break;
                    }
                    this.closeTag(stringBuilder);
                    bl = true;
                    String string = object.getStringValue();
                    if (string.length() > 200) {
                        stringBuilder.append(string.substring(0, 200) + "...");
                    } else {
                        stringBuilder.append(string);
                    }
                    this.endSection(stringBuilder, 0);
                }
                if (n != 0) {
                    stringBuilder.append('/');
                } else if (this.leaf) {
                    stringBuilder.append("</");
                    this.putName(this.node, stringBuilder);
                    bl = false;
                }
                if (!bl) {
                    this.closeTag(stringBuilder);
                }
                this.endSection(stringBuilder, 2);
                break;
            }
            case 7: {
                stringBuilder.append(this.node.getStringValue());
                this.endSection(stringBuilder, 0);
                break;
            }
            case 6: {
                stringBuilder.append("<!--");
                stringBuilder.append(this.node.getStringValue());
                stringBuilder.append("-->");
                this.endSection(stringBuilder, 4);
                break;
            }
            case 5: {
                stringBuilder.append("<?");
                stringBuilder.append(this.node.getNodeName());
                stringBuilder.append(' ');
                stringBuilder.append(this.node.getStringValue());
                stringBuilder.append("\n?>");
                this.endSection(stringBuilder, 5);
                break;
            }
            case 3: {
                this.putName(this.node, stringBuilder);
                stringBuilder.append("=\"");
                stringBuilder.append(this.node.getStringValue());
                stringBuilder.append('\"');
                this.endSection(stringBuilder, 3);
                break;
            }
            default: {
                stringBuilder.append("?");
            }
        }
        this.stringRep = stringBuilder.toString();
    }

    private void closeTag(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n > 0 && stringBuilder.charAt(n - 1) == '>') {
            return;
        }
        stringBuilder.append('>');
        this.endSection(stringBuilder, 2);
    }

    private XmlNode truncationNode() {
        XmlNode xmlNode = new XmlNode(null, this.tree, false);
        xmlNode.stringRep = "... more ...";
        xmlNode.leaf = true;
        return xmlNode;
    }

    private void putName(Node node, StringBuilder stringBuilder) throws DataModelException {
        QName qName = node.getNodeName();
        String string = qName.getNamespaceURI();
        if (NamespaceContext.XML.equals(string)) {
            stringBuilder.append("xml:");
            stringBuilder.append(qName.getLocalPart());
        } else {
            String string2 = node.getNamespacePrefix(string);
            if (string2 != null) {
                stringBuilder.append(string2);
                if (string2.length() > 0) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(qName.getLocalPart());
            } else {
                stringBuilder.append(qName);
            }
        }
    }

    private boolean isWhiteSpace(Node node) throws DataModelException {
        if (node.getNodeNature() != 7) {
            return false;
        }
        String string = node.getStringValue();
        int n = string.length();
        while (--n >= 0) {
            if (Character.isWhitespace(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    protected String getToolTip() {
        try {
            return this.node.getNodeKind() + " node";
        }
        catch (Exception exception) {
            return "Error: " + exception;
        }
    }
}

