/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.api.util.XMLSerializer;
import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.QizxStudio;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GridBagger;
import com.qizx.apps.util.Property;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MetaEditDialog
extends DialogBase {
    private static final String[] TYPES = new String[]{"string", "integer", "double", "boolean", "dateTime", "node()", "<expression>"};
    private AppFrame app;
    private QizxStudio.PropertyAction target;
    private JLabel messageBox;
    private JTextField nameField;
    private JTextArea valueField;
    private JComboBox typeField;

    public MetaEditDialog(AppFrame appFrame) {
        super(appFrame);
        this.app = appFrame;
        this.setTitle("Edit Metadata Property");
        GridBagger gridBagger = new GridBagger(this.form, 0, 8);
        gridBagger.newRow();
        this.messageBox = new JLabel();
        gridBagger.add(this.messageBox, gridBagger.prop("xfill").spans(2, 1));
        gridBagger.newRow();
        this.addLabel(gridBagger, "Property name");
        this.nameField = new JTextField(20);
        gridBagger.add(this.nameField, gridBagger.prop("xfill"));
        gridBagger.newRow();
        this.addLabel(gridBagger, "Property value");
        this.valueField = new JTextArea(2, 20);
        gridBagger.add(new JScrollPane(this.valueField), gridBagger.prop("fill"));
        gridBagger.newRow();
        this.addLabel(gridBagger, "Property type");
        this.typeField = new JComboBox<String>(TYPES);
        gridBagger.add(this.typeField, gridBagger.prop("left"));
        Help.setDialogHelp(this, "metadata_edit_dialog");
    }

    public void showUp(QizxStudio.PropertyAction propertyAction) throws Exception {
        this.target = propertyAction;
        Property property = propertyAction.property;
        String string = property == null ? null : property.name;
        this.messageBox.setText("");
        if (string == null) {
            this.nameField.setText("");
            this.nameField.setEditable(true);
            this.valueField.setText("");
        } else {
            this.nameField.setText(string);
            this.nameField.setEditable(false);
            this.typeField.setSelectedItem(property.type);
            if (property.nodeValue != null) {
                XMLSerializer xMLSerializer = new XMLSerializer();
                String string2 = xMLSerializer.serializeToString(property.nodeValue);
                this.valueField.setText(string2);
            } else {
                this.valueField.setText(property.value);
            }
        }
        this.showUp();
    }

    public void cmdOK(ActionEvent actionEvent, BasicAction basicAction) {
        try {
            String string = (String)this.typeField.getSelectedItem();
            if (string == null) {
                this.messageBox.setText("a type should be selected");
                return;
            }
            String string2 = this.valueField.getText();
            String string3 = this.nameField.getText();
            Property property = new Property(string3, string2);
            property.type = string;
            this.target.savePropertyValue(property);
            super.cmdOK(actionEvent, basicAction);
        }
        catch (Exception exception) {
            this.app.showError(exception);
        }
    }

    private void addLabel(GridBagger gridBagger, String string) {
        gridBagger.add(new JLabel(string + ": "), gridBagger.prop("right"));
    }
}

