/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GridBagger;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginDialog
extends DialogBase
implements KeyListener {
    private JLabel messageField;
    private JTextField nameField;
    private JPasswordField passwordField;

    public LoginDialog(AppFrame appFrame) {
        super((Frame)appFrame, "Login");
        this.buildContents();
    }

    protected void buildContents() {
        this.setHint("User authentication:", false);
        GridBagger gridBagger = new GridBagger(this.form, 0, 8);
        gridBagger.newRow();
        this.messageField = new JLabel();
        gridBagger.add(this.messageField, gridBagger.spans(2, 1).prop("center"));
        gridBagger.newRow();
        gridBagger.add(new JLabel("Login: "), gridBagger.prop("right"));
        this.nameField = new JTextField();
        BasicAction basicAction = new BasicAction("", "cmdOK", this);
        this.nameField.addActionListener(basicAction);
        this.nameField.addKeyListener(this);
        this.nameField.setColumns(16);
        gridBagger.add(this.nameField, gridBagger.prop("xfill").leftMargin(16));
        gridBagger.newRow();
        gridBagger.add(new JLabel("Password: "), gridBagger.prop("right"));
        this.passwordField = new JPasswordField();
        this.passwordField.addActionListener(basicAction);
        this.passwordField.addKeyListener(this);
        gridBagger.add(this.passwordField, gridBagger.prop("xfill").leftMargin(16));
    }

    public String getLogin() {
        return this.isCancelled() ? null : this.nameField.getText().trim();
    }

    public void setLogin(String string) {
        this.nameField.setText(string);
    }

    public char[] getPassword() {
        return this.isCancelled() ? null : this.passwordField.getPassword();
    }

    public void showUp(String string, String string2) {
        this.messageField.setText(string2);
        this.getOkButton().setEnabled(false);
        this.pack();
        this.showUp(string);
    }

    public void enableLogin(boolean bl) {
        this.nameField.setEnabled(bl);
    }

    public void cmdOK(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.validated()) {
            super.cmdOK(actionEvent, basicAction);
        }
    }

    private boolean validated() {
        String string = this.nameField.getText();
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = this.passwordField.getPassword();
        return cArray != null && cArray.length > 0;
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.getOkButton().setEnabled(this.validated());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

