/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.api.util.XMLSerializer;
import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.ComboSelector;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.FileSelector;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.GridBagger;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.border.TitledBorder;

public class ExportDialog
extends DialogBase
implements ActionListener {
    private static final String[] ENCODINGS = new String[]{"ISO8859-1", "ISO8859-2", "ISO8859-3", "ISO8859-4", "ISO8859-5", "ISO8859-7", "ISO8859-9", "ISO8859-13", "ISO8859-15", "US-ASCII", "UTF-8", "UTF-16", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", "Windows-1257"};
    private static final String[] METHODS = new String[]{"XML", "HTML", "XHTML", "Text"};
    private AppFrame app;
    private FileSelector fileSelector;
    private JLabel messageBox;
    private ComboSelector encodingField;
    private JComboBox methodField;
    private JSpinner indentValueOption;
    private JCheckBox omitDeclOption;
    private JCheckBox indentOption;
    private XMLSerializer serializer;

    public ExportDialog(AppFrame appFrame) {
        super(appFrame);
        this.app = appFrame;
        this.setTitle("Export");
        this.buildContents();
        Help.setDialogHelp(this, "export_document_dialog");
    }

    public XMLSerializer showUp(String string, boolean bl, String string2) {
        this.fileSelector.setPath(string);
        File file = new File(string);
        this.fileSelector.setSuggestedName(file.getName());
        String string3 = bl ? null : "Caution: saved output will not be well-formed XML";
        this.messageBox.setText(string3);
        this.setTitle(string2);
        this.showUp();
        return this.isCancelled() ? null : this.serializer;
    }

    public JFileChooser getFileChooser() {
        return this.fileSelector.getFileChooser();
    }

    public String getFilePath() {
        return this.fileSelector.getPath();
    }

    private void buildContents() {
        GridBagger gridBagger = new GridBagger(this.form, 0, 8);
        gridBagger.newRow();
        this.messageBox = new JLabel();
        this.messageBox.setForeground(new Color(255, 90, 0));
        gridBagger.add(this.messageBox, gridBagger.prop("xfill").spans(2, 1));
        gridBagger.newRow();
        this.fileSelector = new FileSelector(30, true, true);
        this.fileSelector.setBorder(new TitledBorder("Output file: "));
        gridBagger.add(this.fileSelector, gridBagger.prop("xfill").spans(2, 1));
        JFileChooser jFileChooser = this.fileSelector.getFileChooser();
        jFileChooser.setDialogType(1);
        gridBagger.newRow();
        this.addLabel(gridBagger, "Encoding");
        this.encodingField = new ComboSelector("", ENCODINGS, false);
        this.addOption(gridBagger, this.encodingField.getComboBox());
        gridBagger.newRow();
        this.addLabel(gridBagger, "Method");
        this.methodField = new JComboBox<String>(METHODS);
        this.methodField.addActionListener(this);
        this.addOption(gridBagger, this.methodField);
        gridBagger.newRow();
        this.addLabel(gridBagger, "Omit XML Declaration");
        this.omitDeclOption = new JCheckBox();
        this.addOption(gridBagger, this.omitDeclOption);
        gridBagger.newRow();
        this.addLabel(gridBagger, "Indent");
        this.indentOption = new JCheckBox(new BasicAction(null, "cmdIndent", this));
        this.addOption(gridBagger, this.indentOption);
        this.indentOption.setSelected(false);
        gridBagger.newRow();
        this.addLabel(gridBagger, "Indentation");
        this.indentValueOption = new JSpinner();
        GUI.setPreferredWidth(this.indentValueOption, 40);
        this.indentValueOption.setValue(2);
        this.indentValueOption.setEnabled(false);
        this.addOption(gridBagger, this.indentValueOption);
    }

    private void addLabel(GridBagger gridBagger, String string) {
        gridBagger.add(new JLabel(string + ":  "), gridBagger.prop("right"));
    }

    private void addOption(GridBagger gridBagger, JComponent jComponent) {
        gridBagger.add(jComponent, gridBagger.prop("left"));
    }

    public void cmdIndent(ActionEvent actionEvent, BasicAction basicAction) {
        this.indentValueOption.setEnabled(this.indentOption.isSelected());
    }

    public void cmdOK(ActionEvent actionEvent, BasicAction basicAction) {
        String string = this.fileSelector.getPath();
        if (string == null) {
            return;
        }
        this.fileSelector.setSuggestedFile(string);
        this.serializer = new XMLSerializer();
        try {
            String string2 = (String)this.methodField.getSelectedItem();
            this.serializer.setOption("method", string2);
            String string3 = (String)this.encodingField.getValue();
            this.serializer.setOption("encoding", string3);
            this.serializer.setOption("omit-xml-declaration", Boolean.toString(this.omitDeclOption.isSelected()));
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.serializer.setOutput(fileOutputStream, string3);
            if (this.indentOption.isSelected()) {
                Integer n = (Integer)this.indentValueOption.getValue();
                this.serializer.setIndent(n);
            }
            super.cmdOK(actionEvent, basicAction);
        }
        catch (Exception exception) {
            this.app.showError(exception);
        }
    }

    private String replaceExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ("XML".equals(string2)) {
            return string + ".xml";
        }
        if ("Text".equals(string2)) {
            return string + ".txt";
        }
        return string + ".html";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.methodField.getSelectedItem();
        String string2 = this.replaceExtension(this.fileSelector.getPath(), string);
        this.fileSelector.setPath(string2);
    }
}

