/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio;

import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QizxException;
import com.qizx.api.util.XMLSerializer;
import com.qizx.apps.studio.QizxStudio;
import com.qizx.apps.studio.XQDataView;
import com.qizx.apps.studio.dialogs.ExportDialog;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.TreePort;
import com.qizx.apps.studio.gui.XdmNode;
import com.qizx.apps.studio.gui.XmlNode;
import com.qizx.apps.util.QizxConnector;
import com.qizx.util.basic.QueueWorker;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class XQResultView
extends XQDataView {
    private static final String SETT_RESULTS_PATH = "results_path";
    private static final String RESULTS_USE_MARKUP = "results.use_markup";
    private Icon atomIcon;
    private BasicAction prevPageAction;
    private BasicAction nextPageAction;
    private BasicAction firstPageAction;
    private BasicAction lastPageAction;
    private BasicAction exportAction;
    private QizxStudio studio;
    private QueueWorker waiter;
    private BasicAction finishAction;
    private QizxConnector connector;
    private StatusHandler statusHandler;
    private QizxConnector.Query cachedQuery;
    private Throwable execError;
    private long execTime;
    private boolean initialExec;
    private int pageSize = 100;
    private int pageStart;
    private List<Item> pageItems;
    private long totalItemCount;
    private Runnable executionTask = new Runnable(){

        public void run() {
            XQResultView.this.execError = null;
            XQResultView.this.execTime = 0L;
            long l = System.currentTimeMillis();
            try {
                XQResultView.this.pageItems = XQResultView.this.connector.execute(XQResultView.this.cachedQuery, XQResultView.this.pageStart, XQResultView.this.pageSize);
            }
            catch (Throwable throwable) {
                XQResultView.this.execError = throwable;
                XQResultView.this.pageItems = null;
            }
            XQResultView.this.execTime = System.currentTimeMillis() - l;
            SwingUtilities.invokeLater(XQResultView.this.displayTask);
        }
    };
    private Runnable displayTask = new Runnable(){

        public void run() {
            XQResultView.this.app.waitCursor(false);
            XQResultView.this.totalItemCount = XQResultView.this.cachedQuery.getTotalItemCount();
            XQResultView.this.refreshPage();
            XQResultView.this.actionStatus();
            if (XQResultView.this.finishAction != null) {
                XQResultView.this.finishAction.actionPerformed(null);
                XQResultView.this.finishAction = null;
            }
            if (XQResultView.this.statusHandler != null) {
                XQResultView.this.statusHandler.executionStatus(XQResultView.this.totalItemCount, XQResultView.this.initialExec, XQResultView.this.execTime, XQResultView.this.execError);
            }
            XQResultView.this.initialExec = false;
        }
    };

    public XQResultView(QizxStudio qizxStudio, String string, boolean bl) {
        super(qizxStudio, string, bl);
        this.studio = qizxStudio;
        this.atomIcon = qizxStudio.getIcon("atom.gif");
        this.useMarkup = qizxStudio.getBoolSetting(RESULTS_USE_MARKUP, true);
        this.markupButton.setSelected(this.useMarkup);
        this.exportAction = new BasicAction(null, qizxStudio.getIcon("save.png"), "cmdSaveResults", this);
        this.addToolSpace(10, 0);
        this.addToolbarButton(this.exportAction, "Save results", "results_save");
        this.nextPageAction = new BasicAction(null, qizxStudio.getIcon("resultset_next.png"), "cmdNextPage", this);
        this.prevPageAction = new BasicAction(null, qizxStudio.getIcon("resultset_prev.png"), "cmdPrevPage", this);
        this.firstPageAction = new BasicAction(null, qizxStudio.getIcon("resultset_first.png"), "cmdFirstPage", this);
        this.lastPageAction = new BasicAction(null, qizxStudio.getIcon("resultset_last.png"), "cmdLastPage", this);
        this.actionStatus();
        this.addToolSpace(10, 0);
        this.addToolbarButton(this.lastPageAction, "Display last results", "results_lp");
        this.addToolbarButton(this.nextPageAction, "Display next results", "results_np");
        this.addToolbarButton(this.prevPageAction, "Display previous results", "results_pp");
        this.addToolbarButton(this.firstPageAction, "Display first results", "results_fp");
    }

    public StatusHandler getStatusHandler() {
        return this.statusHandler;
    }

    public void setStatusHandler(StatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    public void saveSettings() {
        this.app.saveSetting(RESULTS_USE_MARKUP, this.useMarkup);
    }

    public void execQuery(String string, QizxConnector qizxConnector, String string2, String string3, BasicAction basicAction) {
        this.connector = qizxConnector;
        this.finishAction = basicAction;
        this.cachedQuery = new QizxConnector.Query(string, string2);
        this.cachedQuery.setQueryDomain(string3);
        this.initialExec = true;
        this.pageStart = 0;
        this.totalItemCount = 0L;
        this.displayPageItems();
    }

    public void cancelQuery() {
        if (this.cachedQuery != null) {
            this.cachedQuery.cancel();
        }
    }

    public void cmdFirstPage(ActionEvent actionEvent, BasicAction basicAction) {
        this.pageStart = 0;
        this.displayPageItems();
    }

    public void cmdPrevPage(ActionEvent actionEvent, BasicAction basicAction) {
        this.pageStart -= this.pageSize;
        this.displayPageItems();
    }

    public void cmdNextPage(ActionEvent actionEvent, BasicAction basicAction) {
        this.pageStart += this.pageSize;
        this.displayPageItems();
    }

    public void cmdLastPage(ActionEvent actionEvent, BasicAction basicAction) {
        this.pageStart = (int)((this.totalItemCount - 1L) / (long)this.pageSize) * this.pageSize;
        this.displayPageItems();
    }

    public void cmdMarkupView(ActionEvent actionEvent, BasicAction basicAction) {
        this.useMarkup = true;
        this.refreshPage();
    }

    public void cmdDMView(ActionEvent actionEvent, BasicAction basicAction) {
        this.useMarkup = false;
        this.refreshPage();
    }

    public void cmdSaveResults(ActionEvent actionEvent, BasicAction basicAction) {
        String string = "Export results to file";
        boolean bl = this.totalItemCount == 1L && this.pageItems.get(0) instanceof Node;
        String string2 = this.app.getSetting(SETT_RESULTS_PATH);
        if (string2 == null) {
            string2 = "results.xml";
        }
        ExportDialog exportDialog = this.studio.getExportDialog();
        XMLSerializer xMLSerializer = exportDialog.showUp(string2, bl, string);
        this.app.saveSetting(SETT_RESULTS_PATH, exportDialog.getFilePath());
        if (xMLSerializer == null) {
            return;
        }
        try {
            List<Item> list = this.connector.execute(this.cachedQuery, 0, -1);
            for (Item item : list) {
                if (item instanceof Node) {
                    xMLSerializer.putNodeCopy(item.getNode(), 0);
                } else {
                    xMLSerializer.putAtomText(item.getString());
                }
                xMLSerializer.println();
            }
            xMLSerializer.flush();
            xMLSerializer.getOutput().close();
        }
        catch (Throwable throwable) {
            this.app.showError(throwable);
            return;
        }
    }

    private void displayPageItems() {
        if (this.waiter == null) {
            this.waiter = new QueueWorker("XQExecutor");
            this.waiter.start();
        }
        this.app.waitCursor(true);
        this.waiter.queueTask(this.executionTask);
    }

    private void actionStatus() {
        this.lastPageAction.setEnabled((long)(this.pageStart + this.pageSize) < this.totalItemCount);
        this.nextPageAction.setEnabled((long)(this.pageStart + this.pageSize) < this.totalItemCount);
        this.prevPageAction.setEnabled(this.pageStart > 0);
        this.firstPageAction.setEnabled(this.pageStart > 0);
        this.exportAction.setEnabled(this.pageItems != null);
    }

    private void refreshPage() {
        long l = Math.min((long)(this.pageStart + this.pageSize), this.totalItemCount);
        if (this.totalItemCount == 0L) {
            this.changeTitle(" Result items: none");
        } else {
            this.changeTitle(" Result items " + (this.pageStart + 1) + " to " + l + " of " + this.totalItemCount);
        }
        this.changeRoot(new ResultItems());
        this.expandAllVisible(40);
        this.getTree().scrollRowToVisible(0);
    }

    public class ItemNode
    extends TreePort.TNode {
        Item item;
        String type;

        ItemNode(Item item) {
            this.item = item;
        }

        public ItemNode(Node node, String string) {
            this.item = node;
            this.type = string;
            try {
                if (string == null && this.item.getType() != null) {
                    this.type = this.item.getType().getShortName();
                }
            }
            catch (EvaluationException evaluationException) {
                System.err.println("cannot get type of item: " + evaluationException);
            }
        }

        public Icon getIcon(boolean bl, boolean bl2) {
            return XQResultView.this.atomIcon;
        }

        protected String getToolTip() {
            if (this.item == null) {
                return null;
            }
            return "an item of type " + this.type;
        }

        public String toString() {
            if (this.item == null) {
                return "...";
            }
            try {
                if (this.type == null) {
                    ItemType itemType = this.item.getType();
                    return itemType + " = " + this.item.getString();
                }
                return this.type + " = " + this.item.getString();
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }

        public boolean isLeaf() {
            try {
                return this.item == null || !this.item.isNode() || this.item.getNode().getFirstChild() == null;
            }
            catch (QizxException qizxException) {
                return true;
            }
        }

        public void procreate() {
        }
    }

    public class ResultItems
    extends TreePort.TNode {
        public void procreate() {
            if (XQResultView.this.pageItems != null) {
                int n = XQResultView.this.pageItems.size();
                for (int i = 0; i < n; ++i) {
                    Item item = (Item)XQResultView.this.pageItems.get(i);
                    if (item == null || !item.isNode()) {
                        this.add(new ItemNode(item));
                        continue;
                    }
                    if (XQResultView.this.useMarkup) {
                        this.add(new XmlNode((Node)item, XQResultView.this));
                        continue;
                    }
                    this.add(new XdmNode((Node)item));
                }
            }
        }
    }

    public static interface StatusHandler {
        public void executionStatus(long var1, boolean var3, long var4, Throwable var6);
    }
}

