/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio;

import com.qizx.api.QizxException;
import com.qizx.api.util.text.LexicalTokenizer;
import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.TextPort;
import com.qizx.util.basic.FileUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Style;

public class XQEditor
extends TextPort
implements DocumentListener {
    private static final String BANNER = " Query editor";
    private static final int RECOLOR_DELAY = 300;
    private AppFrame app;
    private File currentFile;
    private String shortFileName;
    private boolean modified;
    private boolean locked;
    private Style[] tokenStyles;
    final ActionListener redoSyntax = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n;
                XQEditor.this.synColorTimer.stop();
                String string = XQEditor.this.text.getText();
                StringBuffer stringBuffer = new StringBuffer(string.length());
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    n = string.charAt(i);
                    if (n == 13) continue;
                    stringBuffer.append((char)n);
                }
                string = stringBuffer.toString();
                XQEditor.this.enableUndoEvents(false);
                LexicalTokenizer lexicalTokenizer = new LexicalTokenizer(string);
                n2 = lexicalTokenizer.nextToken();
                while (n2 > 0) {
                    n = lexicalTokenizer.getTokenStart();
                    int n3 = lexicalTokenizer.getTokenLength();
                    XQEditor.this.doc.setCharacterAttributes(n, n3, XQEditor.this.tokenStyles[n2], true);
                    n2 = lexicalTokenizer.nextToken();
                }
            }
            catch (QizxException qizxException) {
            }
            finally {
                XQEditor.this.enableUndoEvents(true);
            }
            XQEditor.this.text.revalidate();
        }
    };
    Timer synColorTimer = new Timer(300, this.redoSyntax);

    public XQEditor(AppFrame appFrame) {
        super(BANNER, 80);
        this.app = appFrame;
        this.enableUndo();
        this.changeFont(0, true);
        this.text.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        JButton jButton = new JButton(new BasicAction(null, appFrame.getIcon("clear.png"), "cmdClear", this));
        jButton.setToolTipText("Clear the query edition area");
        Help.setHelpId(jButton, "xquery_erase");
        GUI.iconic(jButton);
        this.addTool(new JToolBar.Separator(), -1);
        this.addTool(jButton, -1);
        this.doc.addDocumentListener(this);
        this.tokenStyles = new Style[]{this.addStyle("dummy", Color.black), this.addStyle("TAG", new Color(36992)), this.addStyle("SPACE", Color.white), this.addStyle("NUMBER", new Color(8077336)), this.addStyle("STRING", new Color(12615712)), this.addStyle("MISC", new Color(0x303030)), this.addStyle("NAME", new Color(3166432)), this.addStyle("KEYWORD", new Color(16528)), this.addStyle("COMMENT", new Color(5151072)), this.addStyle("PRAGMA", new Color(12619888)), this.addStyle("FUNC", new Color(7352560))};
        this.cmdClear(null, null);
    }

    public void saveSettings() {
    }

    public void cmdClear(ActionEvent actionEvent, BasicAction basicAction) {
        this.setText("");
        this.modified = false;
        this.shortFileName = null;
        this.currentFile = null;
        this.redoBanner(null);
    }

    public File getFile() {
        return this.currentFile;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void loadQuery(File file, String string) throws IOException {
        String string2 = FileUtil.loadString(file, string);
        this.text.setText(string2);
        this.modified = false;
        this.redoBanner(file);
    }

    public void saveQuery(File file, String string) throws IOException {
        FileUtil.saveString(this.text.getText(), file, string);
        this.modified = false;
        this.redoBanner(file);
    }

    public void save(String string) throws IOException {
        this.saveQuery(this.currentFile, string);
    }

    private void redoBanner(File file) {
        if (file != null) {
            this.shortFileName = file.getName();
            this.currentFile = file;
        }
        this.changeTitle(" Query editor: " + (this.shortFileName != null ? this.shortFileName : "") + (this.modified ? " *" : ""));
    }

    void gotChange() {
        if (!this.locked) {
            this.modified = true;
            this.redoBanner(null);
        }
        this.synColorTimer.restart();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.gotChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.gotChange();
    }
}

