/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio;

import com.qizx.api.CompilationException;
import com.qizx.api.EvaluationException;
import com.qizx.api.EvaluationStackTrace;
import com.qizx.api.ItemSequence;
import com.qizx.api.Message;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.api.TraceObserver;
import com.qizx.api.XQuerySession;
import com.qizx.api.XQuerySessionManager;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.util.XMLSerializer;
import com.qizx.api.util.fulltext.DefaultFullTextFactory;
import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.LibraryBrowser;
import com.qizx.apps.studio.MetadataView;
import com.qizx.apps.studio.XQDataView;
import com.qizx.apps.studio.XQEditor;
import com.qizx.apps.studio.XQResultView;
import com.qizx.apps.studio.dialogs.CatalogDialog;
import com.qizx.apps.studio.dialogs.ErrorLogDialog;
import com.qizx.apps.studio.dialogs.ExportDialog;
import com.qizx.apps.studio.dialogs.GroupOpenDialog;
import com.qizx.apps.studio.dialogs.ImportDialog;
import com.qizx.apps.studio.dialogs.LoginDialog;
import com.qizx.apps.studio.dialogs.MetaEditDialog;
import com.qizx.apps.studio.dialogs.ServerConnectDialog;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.GlobFileFilter;
import com.qizx.apps.studio.gui.HistoryMenu;
import com.qizx.apps.studio.gui.HistoryModel;
import com.qizx.apps.studio.gui.TextPort;
import com.qizx.apps.studio.gui.ValueChooser;
import com.qizx.apps.util.Property;
import com.qizx.apps.util.QizxConnector;
import com.qizx.restclient.RESTConnection;
import com.qizx.util.basic.CLOptions;
import com.qizx.util.basic.FileUtil;
import com.qizx.util.basic.PathUtil;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xquery.ExpressionImpl;
import com.qizx.xquery.XMLExprDisplay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class QizxStudio
extends AppFrame
implements XQResultView.StatusHandler,
LibraryBrowser.ActionHandler,
MetadataView.ActionHandler {
    private static final String QUERY_ENCODING = "query-encoding";
    private static final String SETT_TOP_TAB = "topTab";
    private static final String SETT_XTAB_SPLIT = "xtab.split";
    private static final String SETT_XTAB_SPLIT2 = "xtab.split2";
    private static final String SETT_QTAB_SPLIT = "qtab.split";
    private static final String SETT_QTAB_SPLIT2 = "qtab.split2";
    private static final int QHIST_MAX = 50;
    private static final String[] ENCODINGS = new String[]{"(default)", "UTF-8", "UTF-16", "ISO-8859-1", "ISO-8859-15", "Shift_JIS"};
    private static final String MODIFIED_PROCEED = "Query_is_modified:_proceed?";
    private static String APP_NAME = "Qizx Studio";
    private static String APP_NAME_V = APP_NAME + " " + "4.1";
    private static final String DEFAULT_SERVER_URL = "http://localhost:8080/qizx/api";
    static CLOptions options = new CLOptions(APP_NAME);
    public String queryFile;
    public boolean traceQuery;
    public String groupRoot;
    public String libName;
    public String implicitDomain;
    public String baseURI;
    public String moduleBaseURI;
    public String timezone;
    public String collation;
    public int docCache;
    public boolean wizard;
    public boolean observer = true;
    protected ImageIcon saveIcon = this.getIcon("save.gif");
    protected ImageIcon saveAsIcon = this.getIcon("save.gif");
    protected ImageIcon errorIcon = this.getIcon("error.gif");
    protected JTabbedPane toolTabs;
    private JSplitPane xtab;
    private JSplitPane xsplit;
    private JSplitPane qtab;
    private JSplitPane qsplit;
    private LibraryBrowser libBrowser;
    private XQDataView docView;
    private MetadataView metadataView;
    private XQEditor xqEditor;
    private XQResultView resultsView;
    private MessageView messageView;
    private JMenuBar mainMenuBar;
    private JMenu filesMenu;
    private JMenu helpMenu;
    private CatalogDialog catalogDialog;
    private String initialCatalogs;
    private ErrorLogDialog errorLogDialog;
    private JFileChooser libGroupChooser;
    private GroupOpenDialog groupOpenDialog;
    private ServerConnectDialog serverOpenDialog;
    private ImportDialog importDialog;
    private ImportDialog importNXDialog;
    private ExportDialog exportDialog;
    private MetaEditDialog metaEditor;
    private BasicAction newQueryAction;
    private BasicAction loadQueryAction;
    private BasicAction saveQueryAction;
    private BasicAction saveQueryAsAction;
    private BasicAction execAction;
    private BasicAction cancelExecAction;
    private BasicAction finishExecAction;
    private BasicAction dumpExprAction;
    private MemberAction docExportAction;
    private MemberAction openGroupAction;
    private MemberAction connectServerAction;
    private MemberAction closeGroupAction;
    private FileFilter xqFileFilter = new GlobFileFilter("xq");
    private JFileChooser fileChooser;
    private JComboBox fileChooserEncodings;
    private String currentQueryEncoding;
    private HistoryModel recentGroups = new HistoryModel(4, "recentGroup");
    private HistoryModel recentServers = new HistoryModel(4, "recentServer");
    private HistoryModel recentQueryFiles = new HistoryModel(10, "recentQueries");
    public FullTextFactory fulltextFactory = new DefaultFullTextFactory();
    private QizxConnector connector;
    private String currentLibrary;
    private String currentQueryDomain;
    private Properties userSecrets;
    private String userName;
    private String userPassword;
    private HistoryModel qhistory;
    private JButton currentExecButton;
    private JMenu recentFilesMenu;

    public static void main(String[] stringArray) {
        GUI.nativeLookAndFeel();
        QizxStudio qizxStudio = new QizxStudio(APP_NAME_V);
        try {
            options.parse(stringArray, qizxStudio);
            qizxStudio.createGUI();
            qizxStudio.setVisible(true);
            qizxStudio.start();
        }
        catch (CLOptions.Error error) {
            System.exit(0);
        }
        catch (Exception exception) {
            if (qizxStudio.traceExceptions) {
                exception.printStackTrace();
            } else {
                System.err.println("*** " + exception);
            }
            System.exit(1);
        }
    }

    public QizxStudio(String string) {
        super(string);
    }

    public void setTitle(String string) {
        if (string != null) {
            super.setTitle(APP_NAME_V + ": " + string);
        } else {
            super.setTitle(APP_NAME_V);
        }
    }

    public void start() {
        String string;
        this.buildRecentFileMenu();
        try {
            this.waitCursor(true);
            if (this.groupRoot != null) {
                this.openLibraries(this.groupRoot);
            }
            if (this.queryFile != null) {
                this.loadQuery(new File(this.queryFile));
            }
            this.waitCursor(false);
        }
        catch (Exception exception) {
            this.waitCursor(false);
            if (this.traceExceptions) {
                exception.printStackTrace();
            }
            GUI.error(exception.getMessage());
        }
        this.initialCatalogs = CatalogDialog.getCatalogProperty();
        if ((this.initialCatalogs == null || this.initialCatalogs.length() == 0) && (string = this.getSetting("xml.catalogs")) != null) {
            CatalogDialog.setCatalogProperty(string);
        }
    }

    public void setLoginAction(String string) throws Exception {
        int n = string.indexOf(58);
        if (n > 0) {
            this.userPassword = string.substring(n + 1);
            this.userName = string.substring(0, n);
        } else {
            this.userName = string;
        }
    }

    private void createActions() {
        this.connectServerAction = new MemberAction("Connect_to_Server...", "cmdOpenServer", this, null, null, null);
        this.closeGroupAction = new MemberAction("Disconnect", "cmdCloseLibGroup", this, null, null, null);
        this.newQueryAction = this.newBasicAction("New_XQuery", "querynew.png", this, "cmdNewQuery");
        this.loadQueryAction = this.newBasicAction("Open_XQuery_File...", "queryload.png", this, "cmdOpenQuery");
        this.saveQueryAction = this.newBasicAction("Save_XQuery_File...", "querysave.png", this, "cmdSaveQuery");
        this.saveQueryAsAction = this.newBasicAction("Save_XQuery_File_As...", "querysave.png", this, "cmdSaveQueryAs");
        this.dumpExprAction = this.newBasicAction(null, "dumpexpr.png", this, "cmdDumpExpr");
        this.execAction = this.newBasicAction("Execute", "cog_go.png", this, "cmdExecute");
        this.cancelExecAction = this.newBasicAction(" Stop ", "cog_stop.png", this, "cmdCancelExec");
        this.finishExecAction = this.newBasicAction(null, null, this, "cmdFinishExec");
        this.docExportAction = new MemberAction(null, "cmdDocExport", this, null, null, null);
        this.docExportAction.setEnabled(false);
    }

    private void createGUI() {
        Serializable serializable;
        this.setIconImage(GUI.getImage(this.getClass(), "icons/logob16.png"));
        System.setProperty("swing.aatext", "true");
        Help.initialize();
        Help.setHelpId(this, "startPoint");
        this.initGlassPane();
        Rectangle rectangle = this.settings.getGeometry("main.geometry");
        if (rectangle != null) {
            this.setBounds(rectangle);
        } else {
            serializable = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(100, 60, ((Dimension)serializable).width - 200, ((Dimension)serializable).height - 120);
        }
        serializable = (JPanel)this.getContentPane();
        this.toolTabs = new JTabbedPane(1, 0);
        ((Container)serializable).add(this.toolTabs, "Center");
        this.qhistory = new HistoryModel(50, "queries");
        this.qhistory.loadFromPrefs(this.settings);
        this.recentGroups.loadFromPrefs(this.settings);
        this.recentServers.loadFromPrefs(this.settings);
        this.recentQueryFiles.loadFromPrefs(this.settings);
        this.currentQueryEncoding = this.settings.get(QUERY_ENCODING);
        this.createActions();
        this.libBrowser = new LibraryBrowser(this);
        this.libBrowser.setHandler(this);
        Help.setHelpId(this.libBrowser, "xlibs_browser");
        this.docView = new XQDataView(this, "Document", true);
        Help.setHelpId(this.docView, "xlibs_docport");
        JButton jButton = this.docView.addToolbarButton(this.docExportAction, "Export document to file", "doc_export");
        jButton.setIcon(this.getIcon("export.png"));
        this.metadataView = new MetadataView(this);
        Help.setHelpId(this.metadataView, "xlibs_metadata");
        this.metadataView.setHandler(this);
        this.xqEditor = this.createXQEditor();
        this.resultsView = new XQResultView(this, "Query results", true);
        this.resultsView.setStatusHandler(this);
        Help.setHelpId(this.resultsView, "xquery_results");
        this.messageView = new MessageView();
        this.errorLogDialog = new ErrorLogDialog((Frame)this);
        this.qtab = new JSplitPane(1);
        Help.setHelpId(this.qtab, "xquery_tab");
        this.qsplit = new JSplitPane(0);
        this.qtab.setLeftComponent(this.qsplit);
        this.qsplit.setTopComponent(this.xqEditor);
        this.qsplit.setBottomComponent(this.messageView);
        this.qtab.setRightComponent(this.resultsView);
        this.qtab.setResizeWeight(0.5);
        this.qsplit.setResizeWeight(0.6);
        this.toolTabs.addTab("XQuery", null, this.qtab, "Edit and execute a XQuery expression");
        this.toolTabs.setSelectedComponent(this.qtab);
        this.xtab = new JSplitPane(1);
        this.xtab.setLeftComponent(this.libBrowser);
        Help.setHelpId(this.xtab, "xlibs_tab");
        this.xsplit = new JSplitPane(0);
        this.xtab.setRightComponent(this.xsplit);
        this.xsplit.setTopComponent(this.metadataView);
        this.xsplit.setBottomComponent(this.docView);
        this.xtab.setResizeWeight(0.3);
        this.xsplit.setResizeWeight(0.2);
        this.toolTabs.addTab("XML Libraries", null, this.xtab, "Manage and browse a group of XML Libraries");
        int n = this.getIntSetting(SETT_TOP_TAB, 0);
        if (n >= this.toolTabs.getComponentCount()) {
            n = 0;
        }
        this.toolTabs.setSelectedIndex(n);
        int n2 = this.getIntSetting(SETT_XTAB_SPLIT, -1);
        if (n2 > 0) {
            this.xtab.setDividerLocation(n2);
        }
        if ((n2 = this.getIntSetting(SETT_XTAB_SPLIT2, -1)) > 0) {
            this.xsplit.setDividerLocation(n2);
        }
        if ((n2 = this.getIntSetting(SETT_QTAB_SPLIT, -1)) > 0) {
            this.qtab.setDividerLocation(n2);
        }
        if ((n2 = this.getIntSetting(SETT_QTAB_SPLIT2, -1)) > 0) {
            this.qsplit.setDividerLocation(n2);
        }
        this.createMenus();
    }

    private void createMenus() {
        this.mainMenuBar = new JMenuBar();
        this.filesMenu = this.newMenu("F&ile");
        this.mainMenuBar.add(this.filesMenu);
        this.addMenuItem(this.filesMenu, this.newQueryAction, "control N");
        this.addMenuItem(this.filesMenu, this.loadQueryAction, "control O");
        this.addMenuItem(this.filesMenu, this.saveQueryAction, "control S");
        this.addMenuItem(this.filesMenu, this.saveQueryAsAction, "control shift S");
        this.recentFilesMenu = new JMenu("Recent XQuery files");
        this.filesMenu.add(this.recentFilesMenu);
        this.buildRecentFileMenu();
        this.filesMenu.addSeparator();
        this.addMenuItem(this.filesMenu, null, "Q&uit", "control Q", "commandQuit", this);
        JMenu jMenu = this.newMenu("E&dit");
        this.mainMenuBar.add(jMenu);
        this.addMenuItem(jMenu, GUI.getAction(this.xqEditor, "undo"), "control Z");
        this.addMenuItem(jMenu, GUI.getAction(this.xqEditor, "redo"), "control Y");
        jMenu.addSeparator();
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("SmallIcon", this.getIcon("cut.png"));
        JMenuItem jMenuItem = this.addMenuItem(jMenu, cutAction, "control X");
        jMenuItem.setText("Cut");
        jMenuItem.setMnemonic(84);
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("SmallIcon", this.getIcon("copy.png"));
        jMenuItem = this.addMenuItem(jMenu, copyAction, "control C");
        jMenuItem.setText("Copy");
        jMenuItem.setMnemonic(67);
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("SmallIcon", this.getIcon("paste.png"));
        jMenuItem = this.addMenuItem(jMenu, pasteAction, "control V");
        jMenuItem.setText("Paste");
        jMenuItem.setMnemonic(80);
        JMenu jMenu2 = this.newMenu("T&ools");
        this.mainMenuBar.add(jMenu2);
        this.addMenuItem(jMenu2, this.connectServerAction, null);
        this.addMenuItem(jMenu2, this.closeGroupAction, null);
        jMenu2.addSeparator();
        this.addMenuItem(jMenu2, "settings.gif", "X&ML_Catalogs...", null, "cmdXMLCatalogs", this);
        this.addMenuItem(jMenu2, null, "Show Log", null, "cmdShowLog", this);
        this.helpMenu = this.newMenu("H&elp");
        this.mainMenuBar.add(this.helpMenu);
        this.addMenuItem(this.helpMenu, "help.png", "H&elp", "F1", "cmdHelp", this);
        this.addMenuItem(this.helpMenu, "contextual_help.gif", "C&ontextual_Help", null, "cmdHelpContextual", this);
        this.helpMenu.addSeparator();
        this.addMenuItem(this.helpMenu, null, "A&bout " + APP_NAME_V, null, "cmdAbout", this);
        this.setJMenuBar(this.mainMenuBar);
        this.getContentPane().invalidate();
    }

    private XQEditor createXQEditor() {
        JButton jButton;
        final XQEditor xQEditor = new XQEditor(this);
        if (this.wizard) {
            jButton = xQEditor.addButton(this.dumpExprAction, 0);
            GUI.iconic(jButton);
            jButton.setToolTipText("Dump expression");
            HistoryMenu historyMenu = new HistoryMenu("Query history", this.qhistory){

                protected void selected(Object object) {
                    xQEditor.setText(object.toString());
                }
            };
            historyMenu.setIcon(this.getIcon("history.gif"));
            GUI.iconic(historyMenu);
            Help.setHelpId(historyMenu, "xquery_history");
            xQEditor.addTool(historyMenu, 0);
            xQEditor.addToolSpace(10, 0);
        }
        jButton = xQEditor.addButton(this.execAction, 0);
        jButton.setToolTipText("Compile and execute query");
        Help.setHelpId(jButton, "xquery_execute");
        GUI.iconic(jButton);
        return xQEditor;
    }

    protected boolean readyToQuit() {
        try {
            if (this.xqEditor.isModified() && !this.wizard && !this.confirm(this.local(MODIFIED_PROCEED))) {
                return false;
            }
            this.settings.putGeometry("main.geometry", this.getBounds());
            this.saveSetting(SETT_TOP_TAB, this.toolTabs.getSelectedIndex());
            this.saveSetting(SETT_XTAB_SPLIT, this.xtab.getDividerLocation());
            this.saveSetting(SETT_XTAB_SPLIT2, this.xsplit.getDividerLocation());
            this.saveSetting(SETT_QTAB_SPLIT, this.qtab.getDividerLocation());
            this.saveSetting(SETT_QTAB_SPLIT2, this.qsplit.getDividerLocation());
            String string = CatalogDialog.getCatalogProperty();
            if (string != null) {
                this.saveSetting("xml.catalogs", string);
            }
            if (this.qhistory != null) {
                this.qhistory.saveToPrefs(this.settings);
            }
            this.resultsView.saveSettings();
            this.xqEditor.saveSettings();
            this.recentGroups.saveToPrefs(this.settings);
            this.recentServers.saveToPrefs(this.settings);
            this.recentQueryFiles.saveToPrefs(this.settings);
            if (this.currentQueryEncoding != null) {
                this.saveSetting(QUERY_ENCODING, this.currentQueryEncoding);
            }
            this.closeLibraries();
        }
        catch (Exception exception) {
            this.showError("Problem saving settings", exception);
        }
        return true;
    }

    void closeLibraries() {
        if (this.connector != null) {
            try {
                this.libBrowser.setConnector(null);
                this.connector.close();
                this.connector = null;
            }
            catch (Exception exception) {
                this.showError("Closing Library access", exception);
            }
        }
        this.setTitle(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openLibraries(String string) throws Exception {
        if (string.startsWith("http:")) {
            try {
                this.waitCursor(true);
                if (!this.connectToServer(string)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.waitCursor(false);
            }
            this.recentServers.addItem(string);
        }
        return this.setConnector(string);
    }

    private boolean setConnector(String string) throws Exception {
        this.libBrowser.setConnector(this.connector);
        String[] stringArray = this.connector.listLibraries();
        this.currentLibrary = null;
        if (stringArray != null && stringArray.length > 0) {
            this.currentLibrary = stringArray[0];
        }
        this.connector.enableBinding(null);
        this.notification("current Library: " + this.currentLibrary);
        this.setTitle(string);
        return true;
    }

    private boolean connectToServer(String string) throws IOException {
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return QizxStudio.this.authenticate(this.getRequestingPrompt(), this.getRequestingHost());
            }
        });
        RESTConnection rESTConnection = null;
        try {
            rESTConnection = new RESTConnection(string);
            rESTConnection.login();
        }
        catch (IOException iOException) {
            this.showError("server connection error on " + string + "\n", iOException);
            return false;
        }
        this.connector = new QizxConnector(rESTConnection);
        return true;
    }

    protected PasswordAuthentication authenticate(String string, String string2) {
        if (this.userName != null && this.userPassword != null) {
            return new PasswordAuthentication(this.userName, this.userPassword.toCharArray());
        }
        LoginDialog loginDialog = new LoginDialog(this);
        Help.setDialogHelp(loginDialog, "login_server_dialog");
        loginDialog.showUp("Login", string + " from " + string2);
        if (loginDialog.isCancelled()) {
            return null;
        }
        String string3 = loginDialog.getLogin();
        char[] cArray = loginDialog.getPassword();
        return new PasswordAuthentication(string3, cArray);
    }

    private void notification(String string) {
        this.messageView.appendText(string + "\n", this.messageView.noStyle);
    }

    private void message(String string) {
        this.messageView.appendText(string, null);
    }

    public void message(String string, AttributeSet attributeSet) {
        this.messageView.appendText(string, attributeSet);
    }

    public void hyperLink(String string, Object object) {
        this.messageView.hyperlinkMessage(string, this.messageView.linkStyle, object);
    }

    public void cmdAbout(ActionEvent actionEvent, BasicAction basicAction) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.totalMemory();
        long l2 = (l - runtime.freeMemory()) / 1024L;
        long l3 = runtime.maxMemory() / 1024L;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(1);
        boolean bl = System.getProperty("com.qizx.fe") != null;
        String string = System.getProperty("com.qizx.fe.expires");
        String string2 = "http://www.xmlmind.com/qizx/";
        String string3 = "<html><body>Qizx/open 4.1" + ("".length() > 0 ? "  ( variant)" : "") + "<br ><br >" + "Copyright \u00a9 2003-" + n + " " + "XMLmind" + ", all rights reserved." + "<br><br>" + "For more information, please visit " + "<a href='" + string2 + "'>" + string2 + "</a>\n" + "<br> <br> " + "<hr><br>Credits:<p>Most icons by Mark James: famfamfam.com" + "<br> <br> <hr><br>" + "JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.info") + "<br>" + "Memory used " + l2 + " Kb, maximum " + l3 + " Kb\n\n";
        JOptionPane.showMessageDialog(this, new JLabel(string3), "About " + APP_NAME, -1, null);
    }

    public void cmdXMLCatalogs(ActionEvent actionEvent, BasicAction basicAction) {
        this.catalogDialog = new CatalogDialog(this);
        this.catalogDialog.showUp();
    }

    public void cmdShowLog(ActionEvent actionEvent, BasicAction basicAction) {
        this.errorLogDialog.showUp();
    }

    private void buildRecentFileMenu() {
        this.recentFilesMenu.removeAll();
        for (int i = 0; i < this.recentQueryFiles.getSize(); ++i) {
            String string = (String)this.recentQueryFiles.getElementAt(i);
            String string2 = "" + (i + 1) + " " + string;
            RecentFileAction recentFileAction = new RecentFileAction(string2, string);
            this.recentFilesMenu.add(recentFileAction);
        }
    }

    public void cmdNewQuery(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.xqEditor.isModified() && !this.confirm(this.local(MODIFIED_PROCEED))) {
            return;
        }
        this.xqEditor.cmdClear(actionEvent, basicAction);
    }

    public void cmdOpenRecentQuery(ActionEvent actionEvent, RecentFileAction recentFileAction) {
        if (this.xqEditor.isModified() && !this.confirm(this.local(MODIFIED_PROCEED))) {
            return;
        }
        String string = recentFileAction.filePath;
        try {
            this.loadQuery(new File(string));
            this.recentQueryFiles.addItem(string);
        }
        catch (IOException iOException) {
            this.showError("cannot read file " + string + ": " + iOException.getMessage());
            this.recentQueryFiles.removeElement(string);
        }
        this.buildRecentFileMenu();
    }

    public void cmdOpenQuery(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.xqEditor.isModified() && !this.confirm(this.local(MODIFIED_PROCEED))) {
            return;
        }
        this.getFileChooser("Open XQuery source file");
        this.fileChooser.removeChoosableFileFilter(this.xqFileFilter);
        this.fileChooser.addChoosableFileFilter(this.xqFileFilter);
        int n = this.fileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        try {
            this.loadQuery(file);
            this.recentQueryFiles.addItem(file.getCanonicalPath());
            this.buildRecentFileMenu();
        }
        catch (IOException iOException) {
            this.showError("cannot read file " + file + ": " + iOException.getMessage());
        }
    }

    public void cmdSaveQueryAs(ActionEvent actionEvent, BasicAction basicAction) {
        int n;
        this.getFileChooser("Save XQuery source file");
        File file = this.xqEditor.getFile();
        if (file != null) {
            this.fileChooser.setCurrentDirectory(file.getParentFile());
        }
        if ((n = this.fileChooser.showSaveDialog(this)) != 0) {
            return;
        }
        File file2 = this.fileChooser.getSelectedFile();
        String string = (String)this.fileChooserEncodings.getSelectedItem();
        if ("(default)".equals(string)) {
            string = null;
        }
        if (file2.exists() && !GUI.confirmation("File exists", "File " + file2 + " exists: proceed?")) {
            return;
        }
        try {
            this.xqEditor.saveQuery(file2, string);
            this.recentQueryFiles.addItem(file2.getCanonicalPath());
            this.buildRecentFileMenu();
        }
        catch (IOException iOException) {
            this.showError(iOException);
        }
    }

    public void cmdSaveQuery(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.xqEditor.getFile() == null) {
            this.cmdSaveQueryAs(actionEvent, basicAction);
        } else {
            try {
                this.xqEditor.save(this.currentQueryEncoding);
            }
            catch (IOException iOException) {
                this.showError(iOException);
            }
        }
    }

    private void loadQuery(File file) throws IOException {
        String string;
        String string2 = string = this.fileChooserEncodings == null ? null : (String)this.fileChooserEncodings.getSelectedItem();
        if ("(default)".equals(string)) {
            string = null;
        }
        this.currentQueryEncoding = string;
        this.xqEditor.loadQuery(file, string);
    }

    public void cmdExecute(ActionEvent actionEvent, BasicAction basicAction) throws QizxException {
        this.waitCursor(true);
        this.currentExecButton = (JButton)actionEvent.getSource();
        this.currentExecButton.setAction(this.cancelExecAction);
        String string = this.xqEditor.getText();
        if (this.connector == null) {
            this.connector = new QizxConnector(".");
            this.connector.enableBinding(null);
        }
        this.resultsView.execQuery(string, this.connector, this.currentLibrary, this.currentQueryDomain, this.finishExecAction);
        if (this.qhistory != null) {
            this.qhistory.addItem(string);
        }
    }

    public void cmdCancelExec(ActionEvent actionEvent, BasicAction basicAction) {
        this.resultsView.cancelQuery();
    }

    public void cmdFinishExec(ActionEvent actionEvent, BasicAction basicAction) {
        this.currentExecButton.setAction(this.execAction);
    }

    public void executionStatus(long l, boolean bl, long l2, Throwable throwable) {
        if (throwable != null) {
            Style style = this.messageView.errorStyle;
            if (throwable instanceof IOException) {
                this.message(throwable.getMessage() + "\n", style);
            } else if (throwable instanceof CompilationException) {
                this.message("Compilation: " + throwable.getMessage() + "\n", style);
                this.displayMessages(((CompilationException)throwable).getMessages());
            } else if (throwable instanceof EvaluationException) {
                EvaluationException evaluationException = (EvaluationException)throwable;
                QName qName = evaluationException.getErrorCode();
                String string = qName == null ? "?" : qName.getLocalPart();
                this.message("Execution error " + string + ": " + throwable.getMessage() + "\n", style);
                this.printStack(evaluationException.getStack());
            } else {
                String string = throwable.getClass().getSimpleName();
                this.message("error " + string + ": " + throwable.getMessage() + "\n", style);
            }
        } else if (bl) {
            this.messageView.appendText(l + " items in " + l2 + " ms\n", this.messageView.noStyle);
        } else {
            this.messageView.appendText("retrieval time " + l2 + " ms\n", null);
        }
    }

    void displayMessages(Message[] messageArray) {
        for (int i = 0; i < messageArray.length; ++i) {
            Message message = messageArray[i];
            boolean bl = message.getType() == 1;
            Style style = bl ? this.messageView.errorStyle : this.messageView.noStyle;
            String string = bl ? "* " : "  ";
            this.message(string, style);
            if (bl || message.getType() == 2) {
                this.message(" [");
                this.hyperLink(this.printLocation(message), message);
                this.message("] ");
            }
            this.message(message.getText(), style);
            this.message("\n");
        }
    }

    void printStack(EvaluationStackTrace[] evaluationStackTraceArray) {
        for (int i = 0; i < evaluationStackTraceArray.length; ++i) {
            EvaluationStackTrace evaluationStackTrace = evaluationStackTraceArray[i];
            this.showFrame(evaluationStackTrace);
        }
    }

    private void showFrame(EvaluationStackTrace evaluationStackTrace) {
        this.message(" [");
        String string = evaluationStackTrace.getModuleURI() == null ? "line " : evaluationStackTrace.getModuleURI() + ":";
        this.hyperLink(string + evaluationStackTrace.getLineNumber(), evaluationStackTrace);
        this.message("] ");
        if (evaluationStackTrace.getSignature() != null) {
            this.message("function ");
            this.message(evaluationStackTrace.getSignature());
        } else {
            this.message("main query");
        }
        this.message("\n");
    }

    private String printLocation(Message message) {
        return message.getModuleURI() == null ? "line " + message.getLineNumber() : message.getModuleURI() + ":" + message.getLineNumber();
    }

    public void cmdDumpExpr(ActionEvent actionEvent, BasicAction basicAction) {
        String string = this.xqEditor.getText();
        try {
            XQuerySessionManager xQuerySessionManager = new XQuerySessionManager(new URL("file:."));
            XQuerySession xQuerySession = xQuerySessionManager.createSession();
            ExpressionImpl expressionImpl = (ExpressionImpl)xQuerySession.compileExpression(string);
            if (expressionImpl != null) {
                CorePushBuilder corePushBuilder = new CorePushBuilder("");
                expressionImpl.dump(new XMLExprDisplay(corePushBuilder));
                BasicNode basicNode = corePushBuilder.harvest();
                this.resultsView.setRootNode(basicNode);
            }
        }
        catch (Exception exception) {
            this.showError(exception);
        }
    }

    public ExportDialog getExportDialog() {
        if (this.exportDialog == null) {
            this.exportDialog = new ExportDialog(this);
        }
        return this.exportDialog;
    }

    public JFileChooser getFileChooser(String string) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            URL uRL = this.getClass().getClassLoader().getResource("examples");
            if (uRL == null) {
                uRL = this.getClass().getClassLoader().getResource(".");
            }
            File file = uRL != null ? FileUtil.urlToFile(uRL) : new File(".");
            this.fileChooser.setCurrentDirectory(file);
            JPanel jPanel = new JPanel();
            this.fileChooserEncodings = new JComboBox<String>(ENCODINGS);
            jPanel.add(this.fileChooserEncodings);
            jPanel.setBorder(new TitledBorder("Encoding: "));
            this.fileChooser.setAccessory(jPanel);
            if (this.currentQueryEncoding != null) {
                this.fileChooserEncodings.setSelectedItem(this.currentQueryEncoding);
            }
        }
        return this.fileChooser;
    }

    public JFileChooser newFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        String string2 = "Select_" + string + "_file";
        String string3 = "current_" + string2;
        jFileChooser.setName(string3);
        jFileChooser.setDialogTitle(this.local(string2));
        jFileChooser.setCurrentDirectory(new File(this.settings.get(string3, ".")));
        return jFileChooser;
    }

    private void haveGroupChooser() {
        if (this.libGroupChooser == null) {
            this.libGroupChooser = this.newFileChooser("group");
            this.libGroupChooser.setFileSelectionMode(1);
            if (this.recentGroups.getSize() > 0) {
                String string = (String)this.recentGroups.getElementAt(0);
                this.libGroupChooser.setSelectedFile(new File(string));
            }
        }
    }

    private void importToCollection(MemberAction memberAction) {
        if (this.importDialog == null) {
            this.importDialog = new ImportDialog(this, false);
        }
        this.importDialog.showUpForImport(memberAction);
    }

    private void importNonXMLToCollection(MemberAction memberAction) {
        if (this.importNXDialog == null) {
            this.importNXDialog = new ImportDialog(this, true);
        }
        this.importNXDialog.showUpForImport(memberAction);
    }

    public void loadSecrets(String string) throws Exception {
        this.userSecrets = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.userSecrets.load(fileInputStream);
            fileInputStream.close();
            this.userName = this.userSecrets.getProperty("login");
            this.userPassword = this.userSecrets.getProperty("password");
            if (this.userName == null || this.userPassword == null) {
                this.fatal("secrets file should define properties 'login' and 'password'");
            }
        }
        catch (IOException iOException) {
            this.fatal("cannot read secret file: " + iOException.getMessage());
        }
    }

    public boolean showOpenDialog(JFileChooser jFileChooser, Component component) {
        boolean bl = jFileChooser.showOpenDialog(component) == 0;
        try {
            this.settings.put(jFileChooser.getName(), jFileChooser.getCurrentDirectory().getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    private void setQueryDomain(String string, String string2) {
        this.selectedLibrary(this.libBrowser, string);
        this.currentQueryDomain = string2;
        this.notification("Query domain is " + (string2 == null ? "" : string2 + " in ") + "Library " + string);
        this.toolTabs.setSelectedComponent(this.qtab);
    }

    public void selectedLibrary(LibraryBrowser libraryBrowser, String string) {
        if (!string.equals(this.currentLibrary)) {
            this.notification("current Library: " + string);
            this.currentLibrary = string;
            this.currentQueryDomain = null;
        }
        this.emptyDocView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectedCollection(LibraryBrowser libraryBrowser, String string, String string2) {
        QizxConnector qizxConnector = libraryBrowser.getConnector();
        if (qizxConnector == null) {
            return;
        }
        try {
            this.waitCursor(true);
            this.emptyDocView();
            List<Property> list = qizxConnector.getMemberProperties(string, string2);
            this.metadataView.setProperties(list, qizxConnector, string, string2);
            this.metadataView.changeTitle(" Properties of Collection " + string2);
        }
        catch (Exception exception) {
            this.showError("cannot get document contents", exception);
        }
        finally {
            this.waitCursor(false);
        }
    }

    private void emptyDocView() {
        this.docView.setRootNode(null);
        this.docView.changeTitle("");
        this.docExportAction.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectedDocument(LibraryBrowser libraryBrowser, String string, String string2) {
        QizxConnector qizxConnector = libraryBrowser.getConnector();
        if (qizxConnector == null || qizxConnector.isClosed()) {
            return;
        }
        try {
            Object object;
            this.waitCursor(true);
            this.docView.changeTitle(" Contents of Document " + string2);
            String string3 = qizxConnector.getMemberNature(string, string2);
            boolean bl = true;
            if ("document".equals(string3)) {
                object = qizxConnector.getDocumentTree(string, string2);
                this.docView.setRootNode((Node)object);
            } else {
                this.docView.setRootNode(null);
                if ("non-xml".equals(string3)) {
                    // empty if block
                }
            }
            this.docExportAction.browser = libraryBrowser;
            this.docExportAction.library = string;
            this.docExportAction.path = string2;
            this.docExportAction.setEnabled(bl);
            object = qizxConnector.getMemberProperties(string, string2);
            this.metadataView.setProperties((List<Property>)object, qizxConnector, string, string2);
            this.metadataView.changeTitle(" Properties of Document " + string2);
        }
        catch (Throwable throwable) {
            this.showError("cannot get document contents", throwable);
        }
        finally {
            this.waitCursor(false);
        }
    }

    public JPopupMenu getDatabaseMenu(LibraryBrowser libraryBrowser) {
        QizxConnector qizxConnector = libraryBrowser.getConnector();
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.connectServerAction = new MemberAction("Connect_to_Server...", "cmdOpenServer", this, libraryBrowser, null, null);
        this.closeGroupAction = new MemberAction("Disconnect", "cmdCloseLibGroup", this, libraryBrowser, null, null);
        jPopupMenu.add(this.connectServerAction);
        jPopupMenu.add(this.closeGroupAction);
        if (qizxConnector != null) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new MemberAction("Create_Library", "cmdCreateLibrary", this, libraryBrowser, null, null));
        }
        return jPopupMenu;
    }

    public JPopupMenu getLibraryMenu(LibraryBrowser libraryBrowser, String string) {
        QizxConnector qizxConnector = libraryBrowser.getConnector();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (qizxConnector != null && qizxConnector.isLocal()) {
            jPopupMenu.add(new MemberAction("Use_Library_as_Query_Domain", "cmdLibSetQueryDomain", this, libraryBrowser, string, null));
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new MemberAction("Import_Documents...", "cmdLibImportDocuments", this, libraryBrowser, string, null));
        jPopupMenu.add(new MemberAction("Import_NonXML_Documents...", "cmdLibImportNXDocuments", this, libraryBrowser, string, null));
        jPopupMenu.addSeparator();
        MemberAction memberAction = new MemberAction("Delete_Library", "cmdLibDelete", this, libraryBrowser, string, null);
        jPopupMenu.add(memberAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Refresh", "cmdRefreshNode", this, libraryBrowser, string, null));
        return jPopupMenu;
    }

    public JPopupMenu getCollectionMenu(LibraryBrowser libraryBrowser, String string, String string2) {
        QizxConnector qizxConnector = libraryBrowser.getConnector();
        JPopupMenu jPopupMenu = new JPopupMenu();
        MemberAction memberAction = new MemberAction("Use_Collection_as_Query_Domain", "cmdColSetQueryDomain", this, libraryBrowser, string, string2);
        jPopupMenu.add(memberAction);
        memberAction.setEnabled(qizxConnector.isLocal());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Import_Documents...", "cmdColImportDocuments", this, libraryBrowser, string, string2));
        jPopupMenu.add(new MemberAction("Import_NonXML_Documents...", "cmdColImportNXDocuments", this, libraryBrowser, string, string2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Create_Sub-Collection...", "cmdColCreateCollection", this, libraryBrowser, string, string2));
        jPopupMenu.add(new MemberAction("Rename_Collection...", "cmdColRename", this, libraryBrowser, string, string2));
        jPopupMenu.add(new MemberAction("Copy_Collection...", "cmdColCopy", this, libraryBrowser, string, string2));
        if (!qizxConnector.isLocal()) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(new MemberAction("Modify_Access_Rights...", "cmdColEditACL", this, libraryBrowser, string, string2));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Delete_Collection", "cmdColDelete", this, libraryBrowser, string, string2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Refresh", "cmdRefreshNode", this, libraryBrowser, string, string2));
        return jPopupMenu;
    }

    public JPopupMenu getDocumentMenu(LibraryBrowser libraryBrowser, String string, String string2) {
        QizxConnector qizxConnector = libraryBrowser.getConnector();
        JPopupMenu jPopupMenu = new JPopupMenu();
        MemberAction memberAction = new MemberAction("Use_Document_as_Query_Domain", "cmdDocSetQueryDomain", this, libraryBrowser, string, string2);
        memberAction.setEnabled(qizxConnector.isLocal());
        jPopupMenu.add(memberAction);
        jPopupMenu.addSeparator();
        MemberAction memberAction2 = new MemberAction("Export_to_File...", "cmdDocExport", this, libraryBrowser, string, string2);
        memberAction2.setEnabled(this.docExportAction.isEnabled());
        jPopupMenu.add(memberAction2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Copy_Document...", "cmdDocCopy", this, libraryBrowser, string, string2));
        jPopupMenu.add(new MemberAction("Rename_Document...", "cmdDocRename", this, libraryBrowser, string, string2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Delete_Document", "cmdDocDelete", this, libraryBrowser, string, string2));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new MemberAction("Refresh", "cmdRefreshNode", this, libraryBrowser, string, string2));
        return jPopupMenu;
    }

    public void cmdCloseLibGroup(ActionEvent actionEvent, MemberAction memberAction) {
        this.closeLibraries();
    }

    public void cmdOpenServer(ActionEvent actionEvent, MemberAction memberAction) {
        if (this.recentServers.getSize() == 0) {
            this.recentServers.addItem(DEFAULT_SERVER_URL);
        }
        if (this.serverOpenDialog == null) {
            this.serverOpenDialog = new ServerConnectDialog(this, this.recentServers);
        }
        this.serverOpenDialog.showUp();
        try {
            if (this.serverOpenDialog.isCancelled()) {
                return;
            }
            String string = this.serverOpenDialog.getSelected();
            if (string == null) {
                return;
            }
            this.closeLibraries();
            if (!this.openLibraries(string)) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GUI.error("Error opening Library group: " + exception);
        }
    }

    public void cmdCreateLibrary(ActionEvent actionEvent, MemberAction memberAction) {
        ValueChooser valueChooser = new ValueChooser((Frame)this, this.local("Create_XML_library..."), "Enter a name for a new XML library");
        valueChooser.setRegexpValidator("[\\w\\p{L}]+");
        valueChooser.showUp();
        String string = valueChooser.getInput();
        if (string == null) {
            return;
        }
        try {
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.createLibrary(string);
            memberAction.browser.refresh(null, null);
        }
        catch (Exception exception) {
            this.showError("Cannot create library " + string, exception);
        }
    }

    public void cmdLibSetQueryDomain(ActionEvent actionEvent, MemberAction memberAction) {
        this.setQueryDomain(memberAction.library, "/");
    }

    public void cmdLibImportDocuments(ActionEvent actionEvent, MemberAction memberAction) {
        this.importToCollection(memberAction);
    }

    public void cmdLibImportNXDocuments(ActionEvent actionEvent, MemberAction memberAction) {
        this.importNonXMLToCollection(memberAction);
    }

    public void cmdLibDelete(ActionEvent actionEvent, MemberAction memberAction) {
        if (!this.confirm(this.local("Do_you_really_want_to_delete") + " " + memberAction.library + " ?")) {
            return;
        }
        try {
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.deleteLibrary(memberAction.library);
            this.metadataView.setProperties(null, null, null, null);
            memberAction.browser.refresh(null, null);
        }
        catch (Exception exception) {
            this.showError("Cannot delete library " + memberAction.library, exception);
        }
    }

    public void cmdColSetQueryDomain(ActionEvent actionEvent, MemberAction memberAction) {
        this.setQueryDomain(memberAction.library, memberAction.path);
    }

    public void cmdColImportDocuments(ActionEvent actionEvent, MemberAction memberAction) {
        this.importToCollection(memberAction);
    }

    public void cmdColImportNXDocuments(ActionEvent actionEvent, MemberAction memberAction) {
        this.importNonXMLToCollection(memberAction);
    }

    public void cmdRefreshNode(ActionEvent actionEvent, MemberAction memberAction) {
        memberAction.refresh();
    }

    public void cmdColCreateCollection(ActionEvent actionEvent, MemberAction memberAction) {
        ValueChooser valueChooser = new ValueChooser((Frame)this, this.local("Create_Sub-collection..."), "Enter collection name");
        Help.setDialogHelp(valueChooser, "create_collection_dialog");
        valueChooser.setRegexpValidator("[^/\\\\:]+");
        String string = valueChooser.enterString("");
        if (string == null) {
            return;
        }
        try {
            String string2 = PathUtil.makePath(memberAction.path, string);
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.createCollection(memberAction.library, string2);
            memberAction.refresh();
        }
        catch (Exception exception) {
            this.showError("Cannot create " + string, exception);
        }
    }

    public void cmdColDelete(ActionEvent actionEvent, MemberAction memberAction) {
        if (!this.confirm(this.local("Do_you_really_want_to_delete") + " " + memberAction.path + " ?")) {
            return;
        }
        try {
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.deleteMember(memberAction.library, memberAction.path);
            this.metadataView.setProperties(null, null, null, null);
            memberAction.refresh();
        }
        catch (Exception exception) {
            this.showError("Cannot delete collection " + memberAction.path, exception);
        }
    }

    public void cmdColCopy(ActionEvent actionEvent, MemberAction memberAction) {
        String string = ValueChooser.enterString(memberAction.browser, "Copy Collection", "Enter destination path for collection ", memberAction.path, null);
        if (string == null) {
            return;
        }
        QizxConnector qizxConnector = memberAction.browser.getConnector();
        try {
            qizxConnector.copyMember(memberAction.library, memberAction.path, string);
            memberAction.refresh();
        }
        catch (Exception exception) {
            this.showError("Cannot copy " + memberAction.path, exception);
            try {
                qizxConnector.rollback(memberAction.library);
            }
            catch (Exception exception2) {
                System.err.println("failed rollback: " + exception2);
            }
        }
    }

    public void cmdColRename(ActionEvent actionEvent, MemberAction memberAction) {
        String string = ValueChooser.enterString(memberAction.browser, "Rename Collection", "Enter destination path for collection ", memberAction.path, null);
        if (string == null) {
            return;
        }
        try {
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.renameMember(memberAction.library, memberAction.path, string);
            memberAction.refresh();
        }
        catch (Exception exception) {
            this.showError("Cannot rename " + memberAction.path, exception);
        }
    }

    public void cmdColEditACL(ActionEvent actionEvent, MemberAction memberAction) {
        QizxConnector qizxConnector = memberAction.browser.getConnector();
        String string = null;
        try {
            string = qizxConnector.getACL(memberAction.library, memberAction.path, false);
        }
        catch (Exception exception) {
            this.showError("error", exception);
            return;
        }
        while (true) {
            if ((string = ValueChooser.enterText(memberAction.browser, "Edit Access Control Lists", 60, 20, "", string, null)) == null) {
                return;
            }
            try {
                qizxConnector.setACL(memberAction.library, string);
            }
            catch (Exception exception) {
                this.showError("error: ", exception);
                continue;
            }
            break;
        }
    }

    public void cmdDocSetQueryDomain(ActionEvent actionEvent, MemberAction memberAction) {
        this.setQueryDomain(memberAction.library, memberAction.path);
    }

    public void cmdDocExport(ActionEvent actionEvent, MemberAction memberAction) {
        String string;
        QizxConnector qizxConnector = memberAction.browser.getConnector();
        try {
            string = qizxConnector.getMemberNature(memberAction.library, memberAction.path);
            if ("non-xml".equals(string)) {
                this.nonXMLExport(memberAction);
                return;
            }
        }
        catch (Exception exception) {
            this.showError(exception);
            return;
        }
        string = FileUtil.fileBaseName(memberAction.path);
        XMLSerializer xMLSerializer = this.getExportDialog().showUp(string, true, "Export document to file");
        if (xMLSerializer == null) {
            return;
        }
        try {
            Node node = this.docView.getRootNode();
            xMLSerializer.putNodeCopy(node, 0);
            xMLSerializer.flush();
            xMLSerializer.getOutput().close();
        }
        catch (Throwable throwable) {
            this.showError(throwable);
        }
    }

    private void nonXMLExport(MemberAction memberAction) {
        try {
            JFileChooser jFileChooser = this.getExportDialog().getFileChooser();
            String string = FileUtil.fileBaseName(memberAction.path);
            jFileChooser.setSelectedFile(new File(jFileChooser.getSelectedFile(), string));
            if (jFileChooser.showSaveDialog(this.getParent()) == 0) {
                QizxConnector qizxConnector = memberAction.browser.getConnector();
                File file = jFileChooser.getSelectedFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                InputStream inputStream = qizxConnector.getNonXMLStream(memberAction.library, memberAction.path);
                FileUtil.copy(inputStream, fileOutputStream, null);
                inputStream.close();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            this.showError(this.local("Exporting") + " from: " + memberAction.library, exception);
        }
    }

    public void cmdDocDelete(ActionEvent actionEvent, MemberAction memberAction) {
        if (!this.confirm(this.local("Do_you_really_want_to_delete") + " " + memberAction.path + " ?")) {
            return;
        }
        try {
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.deleteMember(memberAction.library, memberAction.path);
            this.metadataView.setProperties(null, null, null, null);
            memberAction.refresh();
        }
        catch (Exception exception) {
            this.showError("Cannot delete document " + memberAction.path, exception);
        }
    }

    public void cmdDocCopy(ActionEvent actionEvent, MemberAction memberAction) {
        String string = ValueChooser.enterString(memberAction.browser, "Copy Document", "Enter destination path for document ", memberAction.path, null);
        if (string == null) {
            return;
        }
        try {
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.copyMember(memberAction.library, memberAction.path, string);
            memberAction.refresh();
        }
        catch (Exception exception) {
            this.showError("Cannot copy " + memberAction.path, exception);
        }
    }

    public void cmdDocRename(ActionEvent actionEvent, MemberAction memberAction) {
        String string = ValueChooser.enterString(memberAction.browser, "Rename Document", "Enter destination path for document ", memberAction.path, null);
        if (string == null) {
            return;
        }
        try {
            QizxConnector qizxConnector = memberAction.browser.getConnector();
            qizxConnector.renameMember(memberAction.library, memberAction.path, string);
            memberAction.refresh();
        }
        catch (Exception exception) {
            this.showError("Cannot rename " + memberAction.path, exception);
        }
    }

    public JPopupMenu getPropertiesMenu(MetadataView metadataView, String string, String string2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new PropertyAction("Add_Property...", "cmdMetaAddProperty", this, metadataView, string, string2, null));
        return jPopupMenu;
    }

    public JPopupMenu getPropertyMenu(MetadataView metadataView, String string, String string2, Property property) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new PropertyAction("Edit_Property...", "cmdMetaEditProperty", this, metadataView, string, string2, property));
        jPopupMenu.add(new PropertyAction("Add_Property...", "cmdMetaAddProperty", this, metadataView, string, string2, null));
        jPopupMenu.add(new PropertyAction("Delete_Property", "cmdMetaDeleteProperty", this, metadataView, string, string2, property));
        return jPopupMenu;
    }

    public void cmdMetaAddProperty(ActionEvent actionEvent, PropertyAction propertyAction) {
        try {
            if (this.metaEditor == null) {
                this.metaEditor = new MetaEditDialog(this);
            }
            this.metaEditor.showUp(propertyAction);
            propertyAction.refresh();
        }
        catch (Exception exception) {
            this.showError(this.local("Add_property") + " " + propertyAction.path, exception);
        }
    }

    public void cmdMetaEditProperty(ActionEvent actionEvent, PropertyAction propertyAction) {
        try {
            if (this.metaEditor == null) {
                this.metaEditor = new MetaEditDialog(this);
            }
            this.metaEditor.showUp(propertyAction);
            propertyAction.refresh();
        }
        catch (Exception exception) {
            this.showError(this.local("Edit_property") + " " + propertyAction.path, exception);
        }
    }

    public void cmdMetaDeleteProperty(ActionEvent actionEvent, PropertyAction propertyAction) {
        try {
            propertyAction.savePropertyValue(new Property(propertyAction.property.name, null));
            propertyAction.refresh();
        }
        catch (Exception exception) {
            this.showError(this.local("Delete_property") + " " + propertyAction.path, exception);
        }
    }

    static {
        options.define(null, "<xquery file>...", "=queryFile", "file containing a query to execute.");
        options.define("-login_", "<username[:password]>", "!setLoginAction", "define the login name. If authentication is required and\nthe password is not present, it will be read on the console.\nSee also -auth");
        options.define("-auth_", "<file>", "!loadSecrets", "get the login credentials from a file for convenience.\nIf authentication is required, credentials will be read from this file.\n");
        options.define("-group_", "<directory>", "=groupRoot", "select a group of XML Libraries specified by its root directory");
        options.define("-g_", "<directory>", "=groupRoot", "short form of -group");
        options.define("-i_", "<collection>", "=implicitDomain", "define implicit root for Path expressions: a path expression\nwithout explicit root, like \"//elem\", takes this value as root.\nThis allows writing queries independent of the input data.\nThe value is the same as the argument of function fn:collection():\n- a file path or an URL: for example \"dir1/doc1.xml\"\n- a file pattern: \"dir/*.xml\"\n- a semicolon-separated list of the above elements: \"dizxir1/*.xml;dir2/doc2.xsl\"\n");
        options.define("-domain_", "<collection>", "=implicitDomain", "alias for option -i (implicit path root)");
        options.define("-timezone_", "<time zone>", "=timezone", "Define the implicit timezone, in duration format");
        options.define("-collation_", "<collation>", "=collation", "Define the name of default collation");
        options.define("-doc.cache_", "<size_in_Kb>", "=docCache", "define the parsed document cache size (default 8 Mb)");
        options.define("-tex.", "", "=traceExceptions", "verbose display of exceptions");
        options.define("-wiz.", "", "=wizard", null);
        options.define("-dq.", "", "=traceQuery", null);
        options.define("-lob.", "", "=observer", null);
        options.define("-help@", "", "?", "print this help");
    }

    public class PropertyAction
    extends BasicAction {
        protected MetadataView view;
        public String library;
        public String path;
        public Property property;

        public PropertyAction(String string, String string2, Object object, MetadataView metadataView, String string3, String string4, Property property) {
            super(QizxStudio.this.local(string), string2, object);
            this.view = metadataView;
            this.library = string3;
            this.path = string4;
            this.property = property;
        }

        public void savePropertyValue(Property property) throws Exception {
            QizxConnector qizxConnector = this.view.getConnector();
            qizxConnector.setMemberProperty(this.library, this.path, property);
        }

        public void refresh() {
            QizxConnector qizxConnector = this.view.getConnector();
            try {
                List<Property> list = qizxConnector.getMemberProperties(this.library, this.path);
                this.view.setProperties(list, QizxStudio.this.connector, this.library, this.path);
            }
            catch (Exception exception) {
                QizxStudio.this.showError(exception);
            }
        }
    }

    public class MemberAction
    extends BasicAction {
        public LibraryBrowser browser;
        public String library;
        public String path;

        public MemberAction(String string, String string2, Object object, LibraryBrowser libraryBrowser, String string3, String string4) {
            super(QizxStudio.this.local(string), null, string2, object);
            this.browser = libraryBrowser;
            this.library = string3;
            this.path = string4;
        }

        public void refresh() {
            this.browser.refresh(this.library, this.path);
        }
    }

    class RecentFileAction
    extends BasicAction {
        String filePath;

        public RecentFileAction(String string, String string2) {
            super(string, null, "cmdOpenRecentQuery", QizxStudio.this);
            this.filePath = string2;
        }
    }

    public class MessageView
    extends TextPort
    implements TraceObserver {
        Style errorStyle;
        Style noStyle;
        Style linkStyle;
        Style traceStyle;

        MessageView() {
            super("Messages", -1);
            Help.setHelpId(this, "xquery_messages");
            BasicAction basicAction = new BasicAction(null, QizxStudio.this.getIcon("clear.png"), "cmdClear", this);
            JButton jButton = this.addButton(basicAction, -1);
            GUI.iconic(jButton);
            jButton.setToolTipText("Clear messages");
            this.errorStyle = this.addStyle("ERROR", new Color(0xC00000));
            this.noStyle = this.addStyle("PLAIN", new Color(0x303030));
            this.linkStyle = this.addStyle("LINK", new Color(144));
            this.traceStyle = this.addStyle("TRACE", new Color(0x408000));
            StyleConstants.setUnderline(this.linkStyle, true);
            this.text.addCaretListener(this);
        }

        public void cmdClear(ActionEvent actionEvent, BasicAction basicAction) {
            this.text.setText("");
        }

        protected void linkAction(Object object, int n) {
            int n2 = 0;
            if (object instanceof Message) {
                n2 = ((Message)object).getPosition();
            } else if (object instanceof EvaluationStackTrace) {
                n2 = ((EvaluationStackTrace)object).getPosition();
            }
            QizxStudio.this.xqEditor.select(n2, n2 + 1);
        }

        public void trace(EvaluationStackTrace evaluationStackTrace, ItemSequence itemSequence, String string) {
            StringBuffer stringBuffer = new StringBuffer("TRACE: label=");
            stringBuffer.append(string);
            stringBuffer.append(", value=");
            try {
                for (int i = 0; itemSequence.moveToNextItem() && i < 10; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(itemSequence.getString());
                }
                if (itemSequence.moveToNextItem()) {
                    stringBuffer.append("...");
                }
            }
            catch (EvaluationException evaluationException) {
                stringBuffer.append("!" + evaluationException.toString() + "!");
            }
            stringBuffer.append("\n at ");
        }
    }
}

