/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio;

import com.qizx.apps.studio.XQDataView;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.TreePort;
import com.qizx.apps.studio.gui.XdmNode;
import com.qizx.apps.studio.gui.XmlNode;
import com.qizx.apps.util.Property;
import com.qizx.apps.util.QizxConnector;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataView
extends XQDataView {
    private ActionHandler handler;
    private QizxConnector connector;
    private List<Property> properties;
    private String library;
    private String path;

    public MetadataView(AppFrame appFrame) {
        super(appFrame, "Metadata", true);
        this.app = appFrame;
        this.changeFont(1, false);
        XQDataView.setTreeColors(this.getRenderer());
    }

    public QizxConnector getConnector() {
        return this.connector;
    }

    public void setHandler(ActionHandler actionHandler) {
        this.handler = actionHandler;
    }

    public void setProperties(List<Property> list, QizxConnector qizxConnector, String string, String string2) {
        this.properties = list;
        this.connector = qizxConnector;
        this.library = string;
        this.path = string2;
        this.refresh();
    }

    private void refresh() {
        this.changeRoot(new PropertiesNode());
        this.expandAllVisible(40);
    }

    @Override
    public void cmdMarkupView(ActionEvent actionEvent, BasicAction basicAction) {
        this.useMarkup = true;
        this.refresh();
    }

    @Override
    public void cmdDMView(ActionEvent actionEvent, BasicAction basicAction) {
        this.useMarkup = false;
        this.refresh();
    }

    public class PropertyNode
    extends TreePort.ColoredNode {
        Property property;
        private String stringRep;

        PropertyNode(Property property) {
            this.property = property;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(property.name);
            this.endSection(stringBuilder, 2);
            if (property.type != null) {
                stringBuilder.append(" [");
                stringBuilder.append(property.type);
                stringBuilder.append("]");
                this.endSection(stringBuilder, 3);
            }
            stringBuilder.append(" = ");
            this.endSection(stringBuilder, 0);
            if (property.value != null) {
                stringBuilder.append(property.value);
                this.endSection(stringBuilder, 0);
            }
            this.stringRep = stringBuilder.toString();
        }

        public String toString() {
            return this.stringRep;
        }

        public boolean isLeaf() {
            return this.property.nodeValue == null;
        }

        public void procreate() {
            if (this.property.nodeValue == null) {
                return;
            }
            if (MetadataView.this.useMarkup) {
                this.add(new XmlNode(this.property.nodeValue, MetadataView.this));
            } else {
                this.add(new XdmNode(this.property.nodeValue));
            }
        }

        protected JPopupMenu getPopupMenu() {
            return MetadataView.this.handler == null ? null : MetadataView.this.handler.getPropertyMenu(MetadataView.this, MetadataView.this.library, MetadataView.this.path, this.property);
        }
    }

    public class PropertiesNode
    extends TreePort.TNode {
        PropertiesNode() {
        }

        public void procreate() {
            try {
                for (Property property : MetadataView.this.properties) {
                    this.add(new PropertyNode(property));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected JPopupMenu getPopupMenu() {
            return MetadataView.this.handler == null ? null : MetadataView.this.handler.getPropertiesMenu(MetadataView.this, MetadataView.this.library, MetadataView.this.path);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object instanceof PropertiesNode;
        }
    }

    public static interface ActionHandler {
        public JPopupMenu getPropertiesMenu(MetadataView var1, String var2, String var3);

        public JPopupMenu getPropertyMenu(MetadataView var1, String var2, String var3, Property var4);
    }
}

