/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.ns;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPParams;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public final class Request
extends QueryModule {
    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str method() throws QueryException {
        return Str.get((String)this.request().getMethod());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str scheme() throws QueryException {
        return Str.get((String)this.request().getScheme());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str hostname() throws QueryException {
        return Str.get((String)this.request().getServerName());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Int port() throws QueryException {
        return Int.get((long)this.request().getServerPort());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str path() throws QueryException {
        return Str.get((String)this.request().getRequestURI());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str query() throws QueryException {
        String query = this.request().getQueryString();
        return query == null ? null : Str.get((String)query);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Uri uri() throws QueryException {
        return Uri.uri((String)this.request().getRequestURL().toString());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str contextPath() throws QueryException {
        return Str.get((String)this.request().getContextPath());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str address() throws QueryException {
        return Str.get((String)this.request().getLocalAddr());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str remoteHostname() throws QueryException {
        return Str.get((String)this.request().getRemoteHost());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str remoteAddress() throws QueryException {
        return Str.get((String)this.request().getRemoteAddr());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Int remotePort() throws QueryException {
        return Int.get((long)this.request().getRemotePort());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Value parameterNames() throws QueryException {
        try {
            HTTPParams params = this.connection().params;
            TokenSet cache = new TokenSet();
            for (String name : params.map().keySet()) {
                cache.add(name);
            }
            for (String name : params.form(this.queryContext.context.options).keySet()) {
                cache.add(name);
            }
            TokenList names = new TokenList(cache.size());
            for (byte[] name : cache) {
                names.add((Object)name);
            }
            return StrSeq.get((TokenList)names);
        }
        catch (IOException ex) {
            throw new QueryException((Throwable)ex);
        }
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Value parameter(Str key) throws QueryException {
        return this.parameter(key, null);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Value parameter(Str key, Value def) throws QueryException {
        try {
            String name = key.toJava();
            HTTPParams params = this.connection().params;
            Value query = (Value)params.map().get(name);
            Value form = (Value)params.form(this.queryContext.context.options).get(name);
            if (query == null && form == null) {
                return def;
            }
            if (query == null) {
                return form;
            }
            if (form == null) {
                return query;
            }
            return ValueBuilder.concat((Value)query, (Value)form, (QueryContext)this.queryContext);
        }
        catch (IOException ex) {
            throw new QueryException((Throwable)ex);
        }
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Value headerNames() throws QueryException {
        TokenList tl = new TokenList();
        Enumeration en = this.request().getHeaderNames();
        while (en.hasMoreElements()) {
            tl.add((String)en.nextElement());
        }
        return StrSeq.get((TokenList)tl);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str header(Str key) throws QueryException {
        return this.header(key, null);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str header(Str key, Str def) throws QueryException {
        String val = this.request().getHeader(key.toJava());
        return val == null ? def : Str.get((String)val);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Value cookieNames() throws QueryException {
        TokenList tl = new TokenList();
        Cookie[] cookies = this.request().getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                tl.add(c.getName());
            }
        }
        return StrSeq.get((TokenList)tl);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str cookie(Str key) throws QueryException {
        return this.cookie(key, null);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str cookie(Str key, Str def) throws QueryException {
        String k = key.toJava();
        Cookie[] cookies = this.request().getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(k)) continue;
                return Str.get((String)c.getValue());
            }
        }
        return def;
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str attribute(Str key) throws QueryException {
        Object query = this.request().getAttribute(key.toJava());
        return query == null ? null : Str.get((String)query.toString());
    }

    private HttpServletRequest request() throws QueryException {
        return this.connection().req;
    }

    private HTTPConnection connection() throws QueryException {
        Object http = this.queryContext.http;
        if (http == null) {
            throw QueryError.BASEX_HTTP.get(null, new Object[0]);
        }
        return (HTTPConnection)http;
    }
}

