/*
 * Decompiled with CFR 0.152.
 */
package org.basex.modules;

import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.basex.data.Data;
import org.basex.http.HTTPConnection;
import org.basex.http.SessionListener;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.list.TokenList;

final class ASession {
    private final QueryContext qc;
    private final Str id;
    private HttpSession session;

    ASession(QueryContext qc, Str id) throws QueryException {
        this.qc = qc;
        this.id = id;
        Object http = qc.http;
        if (http == null) {
            throw QueryError.BASEX_HTTP.get(null, new Object[0]);
        }
        if (id == null) {
            this.session = ((HTTPConnection)http).req.getSession();
        } else {
            this.session = (HttpSession)SessionListener.sessions().get(id.toJava());
            if (this.session == null) {
                throw QueryError.SESSIONS_NOTFOUND_X.get(null, new Object[]{id});
            }
        }
    }

    Str id() {
        return Str.get((String)this.session.getId());
    }

    Dtm created() {
        return Dtm.get((long)this.session.getCreationTime());
    }

    Dtm accessed() {
        return Dtm.get((long)this.session.getLastAccessedTime());
    }

    Value names() {
        TokenList tl = new TokenList();
        Enumeration en = this.session.getAttributeNames();
        while (en.hasMoreElements()) {
            tl.add((String)en.nextElement());
        }
        return StrSeq.get((TokenList)tl);
    }

    Value get(Str key) throws QueryException {
        return this.get(key, null);
    }

    Value get(Str key, Value def) throws QueryException {
        Object object = this.session.getAttribute(key.toJava());
        if (object == null) {
            return def;
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        throw (this.id == null ? QueryError.SESSION_GET_X : QueryError.SESSIONS_GET_X).get(null, new Object[]{object});
    }

    void set(Str key, Value value) throws QueryException {
        ValueBuilder vb = new ValueBuilder(this.qc);
        for (Item item : value) {
            if (item instanceof FItem) {
                throw (this.id == null ? QueryError.SESSION_SET_X : QueryError.SESSIONS_SET_X).get(null, new Object[]{item});
            }
            Data data = item.data();
            vb.add((Item)(data == null || data.inMemory() ? item : ((ANode)item).deepCopy(this.qc.context.options, this.qc)));
        }
        this.session.setAttribute(key.toJava(), (Object)vb.value());
    }

    void delete(Str key) {
        this.session.removeAttribute(key.toJava());
    }

    void close() {
        this.session.invalidate();
    }
}

