/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.LockedException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.PreConditionFailedException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.Locale;
import org.basex.http.webdav.WebDAVFolder;
import org.basex.http.webdav.WebDAVMetaData;
import org.basex.http.webdav.WebDAVResource;
import org.basex.http.webdav.WebDAVService;
import org.basex.http.webdav.WebDAVUtils;
import org.basex.util.Util;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class WebDAVResource
implements CopyableResource,
DeletableResource,
MoveableResource,
LockableResource {
    final WebDAVMetaData meta;
    final WebDAVService service;

    WebDAVResource(WebDAVMetaData meta, WebDAVService service) {
        this.meta = meta;
        this.service = service;
    }

    public Object authenticate(String user, String pass) {
        return user;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return WebDAVService.authorize((String)this.meta.db);
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public String getRealm() {
        return "BaseX";
    }

    public String getUniqueId() {
        return null;
    }

    public String getName() {
        return WebDAVUtils.name((String)this.meta.path);
    }

    public Date getModifiedDate() {
        return this.meta.mdate;
    }

    public void delete() throws BadRequestException, NotAuthorizedException {
        new /* Unavailable Anonymous Inner Class!! */.eval();
    }

    public void copyTo(CollectionResource target, String name) throws BadRequestException, NotAuthorizedException {
        new /* Unavailable Anonymous Inner Class!! */.eval();
    }

    public void moveTo(CollectionResource target, String name) throws BadRequestException, NotAuthorizedException {
        new /* Unavailable Anonymous Inner Class!! */.eval();
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        return (LockResult)new /* Unavailable Anonymous Inner Class!! */.evalNoEx();
    }

    public LockResult refreshLock(String token) throws NotAuthorizedException, PreConditionFailedException {
        return (LockResult)new /* Unavailable Anonymous Inner Class!! */.evalNoEx();
    }

    public void unlock(String tokenId) throws NotAuthorizedException, PreConditionFailedException {
        new /* Unavailable Anonymous Inner Class!! */.evalNoEx();
    }

    public LockToken getCurrentLock() {
        return (LockToken)new /* Unavailable Anonymous Inner Class!! */.evalNoEx();
    }

    void del() throws IOException {
        this.service.delete(this.meta.db, this.meta.path);
    }

    void rename(String n) throws IOException {
        this.service.rename(this.meta.db, this.meta.path, n);
    }

    protected abstract void copyToRoot(String var1) throws IOException;

    protected abstract void copyTo(WebDAVFolder var1, String var2) throws IOException;

    void moveToRoot(String n) throws IOException {
        this.copyToRoot(n);
        this.del();
    }

    private void moveTo(WebDAVFolder f, String n) throws IOException {
        if (f.meta.db.equals(this.meta.db)) {
            this.rename(f.meta.path + '/' + n);
        } else {
            this.copyTo(f, n);
            this.del();
        }
    }

    private LockResult lockResource(LockTimeout timeout, LockInfo lockInfo) {
        try {
            String tokenId = this.service.locking.lock(this.meta.db, this.meta.path, lockInfo.scope.name().toLowerCase(Locale.ENGLISH), lockInfo.type.name().toLowerCase(Locale.ENGLISH), lockInfo.depth.name().toLowerCase(Locale.ENGLISH), lockInfo.lockedByUser, timeout.getSeconds());
            return LockResult.success((LockToken)new LockToken(tokenId, lockInfo, timeout));
        }
        catch (IOException ex) {
            Util.debug((Throwable)ex);
            return LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED);
        }
    }

    private LockToken getCurrentActiveLock() throws IOException {
        String lockInfoStr = this.service.locking.lock(this.meta.db, this.meta.path);
        return lockInfoStr == null ? null : WebDAVResource.parseLockInfo((String)lockInfoStr);
    }

    private LockResult refresh(String token) throws IOException {
        this.service.locking.refreshLock(token);
        String lockInfoStr = this.service.locking.lock(token);
        LockToken lockToken = lockInfoStr == null ? null : WebDAVResource.parseLockInfo((String)lockInfoStr);
        return lockToken == null ? LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.ALREADY_LOCKED) : LockResult.success((LockToken)lockToken);
    }

    private static LockToken parseLockInfo(String lockInfo) throws IOException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            LockTokenSaxHandler handler = new LockTokenSaxHandler(null);
            reader.setContentHandler((ContentHandler)handler);
            reader.parse(new InputSource(new StringReader(lockInfo)));
            return LockTokenSaxHandler.access$500((LockTokenSaxHandler)handler);
        }
        catch (SAXException ex) {
            Util.errln((Object)"Error while parsing lock info: %", (Object[])new Object[]{ex});
            return null;
        }
    }

    static /* synthetic */ void access$000(WebDAVResource x0, WebDAVFolder x1, String x2) throws IOException {
        x0.moveTo(x1, x2);
    }

    static /* synthetic */ LockResult access$100(WebDAVResource x0, LockTimeout x1, LockInfo x2) {
        return x0.lockResource(x1, x2);
    }

    static /* synthetic */ LockResult access$200(WebDAVResource x0, String x1) throws IOException {
        return x0.refresh(x1);
    }

    static /* synthetic */ LockToken access$300(WebDAVResource x0) throws IOException {
        return x0.getCurrentActiveLock();
    }
}

