/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqModule;
import org.basex.http.restxq.RestXqParam;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

/*
 * Exception performing whole class analysis ignored.
 */
final class RestXqWadl {
    private final HTTPConnection conn;

    RestXqWadl(HTTPConnection conn) {
        this.conn = conn;
    }

    synchronized FElem create(HashMap<String, RestXqModule> modules) {
        FElem application = new FElem("wadl:application", "http://wadl.dev.java.net/2009/02").declareNS();
        String base = this.conn.req.getRequestURL().toString();
        FElem resources = RestXqWadl.elem((String)"resources", (FElem)application).add("base", base);
        TreeMap<String, FElem> map = new TreeMap<String, FElem>();
        for (RestXqModule mod : modules.values()) {
            for (RestXqFunction func : mod.functions()) {
                TokenList descs;
                if (func.path == null) continue;
                TokenObjMap xqdoc = func.function.doc();
                String path = func.path.toString();
                String methods = func.methods.toString().replaceAll("[^A-Z ]", "");
                FElem resource = new FElem("wadl:resource", "http://wadl.dev.java.net/2009/02").add("path", path);
                map.put(path + '?' + methods, resource);
                Matcher var = Pattern.compile("\\$[^}]*").matcher(path);
                while (var.find()) {
                    RestXqWadl.addParam((String)var.group().substring(1), (String)"template", (FElem)resource, (TokenObjMap)xqdoc, (RestXqFunction)func);
                }
                FElem method = RestXqWadl.elem((String)"method", (FElem)resource).add("name", methods);
                TokenList tokenList = descs = xqdoc != null ? (TokenList)xqdoc.get(Inspect.DOC_DESCRIPTION) : null;
                if (descs != null) {
                    Iterator iterator = descs.iterator();
                    while (iterator.hasNext()) {
                        Iterator desc = (Iterator)((byte[])iterator.next());
                        RestXqWadl.addDoc((byte[])desc, (FElem)method);
                    }
                }
                FElem request = RestXqWadl.elem((String)"request", (FElem)method);
                for (RestXqParam rxp : func.queryParams) {
                    RestXqWadl.addParam((String)rxp.name, (String)"query", (FElem)request, (TokenObjMap)xqdoc, (RestXqFunction)func);
                }
                for (RestXqParam rxp : func.formParams) {
                    RestXqWadl.addParam((String)rxp.name, (String)"query", (FElem)request, (TokenObjMap)xqdoc, (RestXqFunction)func);
                }
                for (RestXqParam rxp : func.headerParams) {
                    RestXqWadl.addParam((String)rxp.name, (String)"header", (FElem)request, (TokenObjMap)xqdoc, (RestXqFunction)func);
                }
                FElem response = RestXqWadl.elem((String)"response", (FElem)method);
                FElem representation = RestXqWadl.elem((String)"representation", (FElem)response);
                representation.add("mediaType", HTTPConnection.mediaType((SerializerOptions)func.output).toString());
            }
        }
        for (FElem elem : map.values()) {
            resources.add((ANode)elem);
        }
        return application;
    }

    private static void addParam(String name, String style, FElem root, TokenObjMap<TokenList> xqdoc, RestXqFunction func) {
        FElem param = RestXqWadl.elem((String)"param", (FElem)root);
        param.add("name", name).add("style", style);
        QNm qn = new QNm(name);
        for (Var var : func.function.params) {
            if (!var.name.eq(qn) || var.declType == null) continue;
            param.add("type", var.declType.toString());
        }
        RestXqWadl.addDoc((byte[])Inspect.doc(xqdoc, (byte[])Token.token((String)name)), (FElem)param);
    }

    private static FElem elem(String name, FElem parent) {
        FElem elem = new FElem("wadl:" + name, "http://wadl.dev.java.net/2009/02");
        if (parent != null) {
            parent.add((ANode)elem);
        }
        return elem;
    }

    private static void addDoc(byte[] xqdoc, FElem parent) {
        if (xqdoc == null) {
            return;
        }
        FElem doc = RestXqWadl.elem((String)"doc", (FElem)parent);
        doc.namespaces().add(Token.EMPTY, Token.token((String)"http://www.w3.org/1999/xhtml"));
        Inspect.add((byte[])xqdoc, (FElem)doc);
    }
}

