/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqModule;
import org.basex.http.restxq.RestXqWadl;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.http.MediaType;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RestXqModules {
    private static volatile RestXqModules instance;
    private final AtomicBoolean parsed = new AtomicBoolean();
    private final IOFile path;
    private final boolean cached;
    private HashMap<String, RestXqModule> modules = new HashMap();
    private long last;

    private RestXqModules(Context ctx) {
        StaticOptions sopts = ctx.soptions;
        String webpath = sopts.get(StaticOptions.WEBPATH);
        String rxqpath = sopts.get(StaticOptions.RESTXQPATH);
        this.path = new IOFile(webpath).resolve(rxqpath);
        int ms = sopts.get(StaticOptions.PARSERESTXQ) * 1000;
        boolean bl = this.cached = ms != 0;
        if (ms >= 0) {
            new Timer(true).scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 0L, 500L);
        }
    }

    public static RestXqModules get(Context ctx) {
        if (instance == null) {
            instance = new RestXqModules(ctx);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        AtomicBoolean atomicBoolean = this.parsed;
        synchronized (atomicBoolean) {
            this.parsed.set(false);
        }
    }

    public FElem wadl(HTTPConnection conn) {
        return new RestXqWadl(conn).create(this.modules);
    }

    RestXqFunction find(HTTPConnection conn, QNm error) throws Exception {
        List funcs = this.find(conn, error, false);
        if (funcs.isEmpty()) {
            return null;
        }
        RestXqFunction first = (RestXqFunction)funcs.get(0);
        for (int l = funcs.size() - 1; l > 0; --l) {
            if (first.compareTo((RestXqFunction)funcs.get(l)) == 0) continue;
            funcs.remove(l);
        }
        if (funcs.size() == 1) {
            return first;
        }
        if ((funcs = RestXqModules.bestQf((List)funcs, (HTTPConnection)conn)).size() == 1) {
            return (RestXqFunction)funcs.get(0);
        }
        TokenBuilder tb = new TokenBuilder();
        for (RestXqFunction func : funcs) {
            tb.add(Text.NL).add("- ").addExt((Object)func.function.name.prefixString(), new Object[0]);
            if (func.produces.isEmpty()) continue;
            tb.add(" ").addExt((Object)func.produces, new Object[0]);
        }
        throw first.path == null ? first.error("Several functions found for error \"%\":%", new Object[]{error, tb}) : first.error("Several functions found for path \"%\":%", new Object[]{first.path, tb});
    }

    List<RestXqFunction> checks(HTTPConnection conn) throws Exception {
        return this.find(conn, null, true);
    }

    private List<RestXqFunction> find(HTTPConnection conn, QNm error, boolean perm) throws Exception {
        ArrayList<RestXqFunction> list = new ArrayList<RestXqFunction>();
        for (RestXqModule mod : this.cache(conn.context).values()) {
            for (RestXqFunction func : mod.functions()) {
                if (!func.matches(conn, error, perm)) continue;
                list.add(func);
            }
        }
        Collections.sort(list);
        return list;
    }

    private static List<RestXqFunction> bestQf(List<RestXqFunction> funcs, HTTPConnection conn) {
        MediaType[] accepts = conn.accepts();
        double cQf = 0.0;
        double sQf = 0.0;
        for (RestXqFunction func : funcs) {
            for (MediaType accept : accepts) {
                if (func.produces.isEmpty()) {
                    cQf = Math.max(cQf, RestXqModules.qf((MediaType)accept, (String)"q"));
                    sQf = 1.0;
                    continue;
                }
                for (MediaType produce : func.produces) {
                    if (!produce.matches(accept)) continue;
                    cQf = Math.max(cQf, RestXqModules.qf((MediaType)accept, (String)"q"));
                    sQf = Math.max(sQf, RestXqModules.qf((MediaType)produce, (String)"qs"));
                }
            }
        }
        List list = RestXqModules.bestQf(funcs, (MediaType[])accepts, (double)cQf, (double)-1.0);
        return list.size() > 1 ? RestXqModules.bestQf(funcs, (MediaType[])accepts, (double)cQf, (double)sQf) : list;
    }

    private static List<RestXqFunction> bestQf(List<RestXqFunction> funcs, MediaType[] accepts, double clientQf, double serverQf) {
        ArrayList<RestXqFunction> list = new ArrayList<RestXqFunction>();
        for (RestXqFunction func : funcs) {
            BooleanSupplier s = () -> {
                for (MediaType accept : accepts) {
                    if (func.produces.isEmpty()) {
                        if (RestXqModules.qf((MediaType)accept, (String)"q") != clientQf) continue;
                        return true;
                    }
                    for (MediaType produce : func.produces) {
                        if (!produce.matches(accept) || RestXqModules.qf((MediaType)accept, (String)"q") != clientQf || serverQf != -1.0 && RestXqModules.qf((MediaType)produce, (String)"qs") != serverQf) continue;
                        return true;
                    }
                }
                return false;
            };
            if (!s.getAsBoolean()) continue;
            list.add(func);
        }
        return list;
    }

    private static double qf(MediaType mt, String f) {
        String qf = (String)mt.parameters().get(f);
        return qf != null ? Token.toDouble((byte[])Token.token((String)qf)) : 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, RestXqModule> cache(Context ctx) throws Exception {
        AtomicBoolean atomicBoolean = this.parsed;
        synchronized (atomicBoolean) {
            if (!this.parsed.get()) {
                if (!this.path.exists()) {
                    throw HTTPCode.NO_RESTXQ.get(new Object[0]);
                }
                HashMap map = new HashMap();
                RestXqModules.cache((Context)ctx, (IOFile)this.path, map, (HashMap)this.modules);
                this.modules = map;
                this.parsed.set(this.cached);
            }
            this.last = System.currentTimeMillis();
            return this.modules;
        }
    }

    private static void cache(Context ctx, IOFile root, HashMap<String, RestXqModule> cache, HashMap<String, RestXqModule> old) throws Exception {
        IOFile[] files;
        for (IOFile file : files = root.children()) {
            if (!file.name().equals(".ignore")) continue;
            return;
        }
        for (IOFile file : files) {
            if (file.isDir()) {
                RestXqModules.cache((Context)ctx, (IOFile)file, cache, old);
                continue;
            }
            String path = file.path();
            if (!file.hasSuffix(IO.XQSUFFIXES)) continue;
            RestXqModule module = old.get(path);
            boolean parsed = false;
            if (module != null) {
                parsed = module.uptodate();
            } else {
                module = new RestXqModule(file);
            }
            if (!parsed && !module.parse(ctx)) continue;
            module.touch();
            cache.put(path, module);
        }
    }

    static /* synthetic */ long access$000(RestXqModules x0) {
        return x0.last;
    }
}

