/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.html.HtmlOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.build.text.TextOptions;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqError;
import org.basex.http.restxq.RestXqModule;
import org.basex.http.restxq.RestXqParam;
import org.basex.http.restxq.RestXqPath;
import org.basex.http.restxq.RestXqPerm;
import org.basex.io.IO;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Catch;
import org.basex.query.expr.Expr;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.http.HttpMethod;
import org.basex.util.http.HttpPayload;
import org.basex.util.http.MediaType;
import org.basex.util.list.TokenList;
import org.basex.util.options.Options;

/*
 * Exception performing whole class analysis ignored.
 */
final class RestXqFunction
implements Comparable<RestXqFunction> {
    private static final Pattern TEMPLATE = Pattern.compile("\\s*\\{\\s*\\$(.+?)\\s*}\\s*");
    private static final Pattern EQNAME = Pattern.compile("^Q\\{(.*?)}(.*)$");
    final ArrayList<RestXqParam> queryParams = new ArrayList();
    final ArrayList<RestXqParam> formParams = new ArrayList();
    final ArrayList<RestXqParam> headerParams = new ArrayList();
    final ArrayList<MediaType> produces = new ArrayList();
    final Set<String> methods = new HashSet();
    final SerializerOptions output;
    final StaticFunc function;
    final TokenList allows = new TokenList();
    private final RestXqModule module;
    private final ArrayList<RestXqParam> errorParams = new ArrayList();
    private final ArrayList<RestXqParam> cookieParams = new ArrayList();
    private final ArrayList<MediaType> consumes = new ArrayList();
    RestXqPath path;
    String singleton;
    private QNm requestBody;
    private RestXqError error;
    private RestXqPerm permission;

    RestXqFunction(StaticFunc function, QueryContext qc, RestXqModule module) {
        this.function = function;
        this.module = module;
        this.output = qc.serParams();
    }

    boolean process(HTTPConnection conn, Object ext) throws Exception {
        try {
            return this.module.process(conn, this, ext);
        }
        catch (QueryException ex) {
            if (ex.file() == null) {
                ex.info(this.function.info);
            }
            throw ex;
        }
    }

    boolean parse(Context ctx) throws Exception {
        boolean[] declared = new boolean[this.function.params.length];
        boolean found = false;
        MainOptions options = ctx.options;
        for (Ann ann : this.function.anns) {
            CsvParserOptions opts;
            Annotation sig = ann.sig;
            if (sig == null) continue;
            found |= Token.eq((byte[])sig.uri, (byte[][])new byte[][]{QueryText.REST_URI, QueryText.PERM_URI});
            Item[] args = ann.args();
            if (sig == Annotation._REST_PATH) {
                try {
                    this.path = new RestXqPath(RestXqFunction.toString((Item)args[0]), ann.info);
                }
                catch (IllegalArgumentException ex) {
                    throw RestXqFunction.error((InputInfo)ann.info, (String)ex.getMessage(), (Object[])new Object[0]);
                }
                for (QNm name : this.path.varNames()) {
                    this.checkVariable(name, (Type)AtomType.AAT, declared);
                }
                continue;
            }
            if (sig == Annotation._REST_ERROR) {
                this.error(ann);
                continue;
            }
            if (sig == Annotation._REST_CONSUMES) {
                RestXqFunction.strings((Ann)ann, (ArrayList)this.consumes);
                continue;
            }
            if (sig == Annotation._REST_PRODUCES) {
                RestXqFunction.strings((Ann)ann, (ArrayList)this.produces);
                continue;
            }
            if (sig == Annotation._REST_QUERY_PARAM) {
                this.queryParams.add(this.param(ann, declared));
                continue;
            }
            if (sig == Annotation._REST_FORM_PARAM) {
                this.formParams.add(this.param(ann, declared));
                continue;
            }
            if (sig == Annotation._REST_HEADER_PARAM) {
                this.headerParams.add(this.param(ann, declared));
                continue;
            }
            if (sig == Annotation._REST_COOKIE_PARAM) {
                this.cookieParams.add(this.param(ann, declared));
                continue;
            }
            if (sig == Annotation._REST_ERROR_PARAM) {
                this.errorParams.add(this.param(ann, declared));
                continue;
            }
            if (sig == Annotation._REST_METHOD) {
                String mth = RestXqFunction.toString((Item)args[0]).toUpperCase(Locale.ENGLISH);
                Item body = args.length > 1 ? args[1] : null;
                this.addMethod(mth, body, declared, ann.info);
                continue;
            }
            if (sig == Annotation._REST_SINGLE) {
                this.singleton = '\u0001' + (args.length > 0 ? RestXqFunction.toString((Item)args[0]) : this.function.info.path() + ':' + this.function.info.line());
                continue;
            }
            if (Token.eq((byte[])sig.uri, (byte[])QueryText.REST_URI)) {
                Item body = args.length == 0 ? null : args[0];
                this.addMethod(Token.string((byte[])sig.local()), body, declared, ann.info);
                continue;
            }
            if (sig == Annotation._INPUT_CSV) {
                opts = new CsvParserOptions((CsvParserOptions)options.get(MainOptions.CSVPARSER));
                options.set(MainOptions.CSVPARSER, RestXqFunction.parse((Options)opts, (Ann)ann));
                continue;
            }
            if (sig == Annotation._INPUT_JSON) {
                opts = new JsonParserOptions((JsonParserOptions)options.get(MainOptions.JSONPARSER));
                options.set(MainOptions.JSONPARSER, RestXqFunction.parse((Options)opts, (Ann)ann));
                continue;
            }
            if (sig == Annotation._INPUT_HTML) {
                opts = new HtmlOptions(options.get(MainOptions.HTMLPARSER));
                options.set(MainOptions.HTMLPARSER, RestXqFunction.parse((Options)opts, (Ann)ann));
                continue;
            }
            if (sig == Annotation._INPUT_TEXT) {
                opts = new TextOptions(options.get(MainOptions.TEXTPARSER));
                options.set(MainOptions.TEXTPARSER, RestXqFunction.parse((Options)opts, (Ann)ann));
                continue;
            }
            if (Token.eq((byte[])sig.uri, (byte[])QueryText.OUTPUT_URI)) {
                try {
                    this.output.assign(Token.string((byte[])sig.local()), RestXqFunction.toString((Item)args[0]));
                    continue;
                }
                catch (BaseXException ex) {
                    Util.debug((Throwable)ex);
                    throw RestXqFunction.error((InputInfo)ann.info, (String)"Unknown serialization parameter: %.", (Object[])new Object[]{sig.local()});
                }
            }
            if (sig == Annotation._PERM_ALLOW) {
                for (Item arg : args) {
                    this.allows.add(RestXqFunction.toString((Item)arg));
                }
                continue;
            }
            if (sig != Annotation._PERM_CHECK) continue;
            String p = args.length > 0 ? RestXqFunction.toString((Item)args[0]) : "";
            QNm v = args.length > 1 ? this.checkVariable(RestXqFunction.toString((Item)args[1]), declared) : null;
            this.permission = new RestXqPerm(p, v);
        }
        for (MediaType produce : this.produces) {
            double d;
            String qf = (String)produce.parameters().get("qs");
            if (qf == null || (d = Token.toDouble((byte[])Token.token((String)qf))) >= 0.0 && d <= 1.0) continue;
            throw RestXqFunction.error((InputInfo)this.function.info, (String)"Invalid quality factor: qs=%", (Object[])new Object[]{qf});
        }
        if (found) {
            int paths = (this.path != null ? 1 : 0) + (this.error != null ? 1 : 0) + (this.permission != null ? 1 : 0);
            if (paths != 1) {
                throw RestXqFunction.error((InputInfo)this.function.info, (String)(paths == 0 ? "Path annotation missing." : "Conflicting path annotations found."), (Object[])new Object[0]);
            }
            int dl = declared.length;
            for (int d = 0; d < dl; ++d) {
                if (declared[d]) continue;
                throw RestXqFunction.error((InputInfo)this.function.info, (String)"Variable $% is not assigned by the annotations.", (Object[])new Object[]{this.function.params[d].name.string()});
            }
        }
        return found;
    }

    private static <O extends Options> O parse(O opts, Ann ann) throws Exception {
        for (Item arg : ann.args()) {
            opts.assign(Token.string((byte[])arg.string(ann.info)));
        }
        return opts;
    }

    private void addMethod(String method, Item body, boolean[] declared, InputInfo info) throws QueryException {
        if (body != null && !body.isEmpty()) {
            HttpMethod m = HttpMethod.get((String)method);
            if (m != null && !m.body) {
                throw RestXqFunction.error((InputInfo)info, (String)"Method % does not allow values.", (Object[])new Object[]{m});
            }
            if (this.requestBody != null) {
                throw RestXqFunction.error((InputInfo)info, (String)"More than one body request variable specified.", (Object[])new Object[0]);
            }
            this.requestBody = this.checkVariable(RestXqFunction.toString((Item)body), declared);
        }
        if (this.methods.contains(method)) {
            throw RestXqFunction.error((InputInfo)info, (String)"Annotation %% is specified twice.", (Object[])new Object[]{"%", method});
        }
        this.methods.add(method);
    }

    boolean matches(HTTPConnection conn, QNm err, boolean perm) {
        if (!this.methods.isEmpty() && !this.methods.contains(conn.method) || !this.consumes(conn) || !this.produces(conn)) {
            return false;
        }
        if (perm) {
            return this.permission != null && this.permission.matches(conn);
        }
        if (err != null) {
            return this.error != null && this.error.matches(err);
        }
        return this.path != null && this.path.matches(conn);
    }

    void bind(HTTPConnection conn, Expr[] args, Object ext, QueryContext qc) throws QueryException, IOException {
        if (this.path != null) {
            for (Map.Entry entry : this.path.values(conn).entrySet()) {
                QNm qnm = new QNm(((QNm)entry.getKey()).string(), this.function.sc);
                if (this.function.sc.elemNS != null && Token.eq((byte[])qnm.uri(), (byte[])this.function.sc.elemNS)) {
                    qnm.uri(Token.EMPTY);
                }
                this.bind(qnm, args, (Value)new Atm((String)entry.getValue()), qc);
            }
        }
        MainOptions mo = conn.context.options;
        if (this.requestBody != null) {
            try {
                this.bind(this.requestBody, args, HttpPayload.value((IO)conn.params.body(), (MainOptions)mo, (MediaType)conn.contentType()), qc);
            }
            catch (IOException ex) {
                throw this.error("Input could not be converted: %", new Object[]{ex});
            }
        }
        for (Object rxp : this.queryParams) {
            this.bind((RestXqParam)rxp, args, (Value)conn.params.map().get(((RestXqParam)rxp).name), qc);
        }
        for (Object rxp : this.formParams) {
            this.bind((RestXqParam)rxp, args, (Value)conn.params.form(mo).get(((RestXqParam)rxp).name), qc);
        }
        for (Object rxp : this.headerParams) {
            TokenList tl = new TokenList();
            Enumeration en = conn.req.getHeaders(((RestXqParam)rxp).name);
            while (en.hasMoreElements()) {
                for (String string : en.nextElement().toString().split(", *")) {
                    tl.add(string);
                }
            }
            this.bind((RestXqParam)rxp, args, StrSeq.get((TokenList)tl), qc);
        }
        Cookie[] ck = conn.req.getCookies();
        for (RestXqParam rxp : this.cookieParams) {
            Empty val = Empty.SEQ;
            if (ck != null) {
                for (Cookie cookie : ck) {
                    if (!rxp.name.equals(cookie.getName())) continue;
                    val = Str.get((String)cookie.getValue());
                }
            }
            this.bind(rxp, args, (Value)val, qc);
        }
        HashMap<String, Value> errs = new HashMap<String, Value>();
        if (ext instanceof QueryException) {
            Value[] values = Catch.values((QueryException)((QueryException)((Object)ext)));
            QNm[] names = Catch.NAMES;
            int n = names.length;
            for (int n2 = 0; n2 < n; ++n2) {
                errs.put(Token.string((byte[])names[n2].local()), values[n2]);
            }
        }
        for (RestXqParam rxp : this.errorParams) {
            this.bind(rxp, args, (Value)errs.get(rxp.name), qc);
        }
        if (ext instanceof RestXqFunction && this.permission.var != null) {
            this.bind(this.permission.var, args, (Value)this.permission.map((RestXqFunction)ext, conn), qc);
        }
    }

    QueryException error(String msg, Object ... ext) {
        return RestXqFunction.error((InputInfo)this.function.info, (String)msg, (Object[])ext);
    }

    private static QueryException error(InputInfo info, String msg, Object ... ext) {
        return QueryError.BASEX_RESTXQ_X.get(info, new Object[]{Util.info((Object)msg, (Object[])ext)});
    }

    @Override
    public int compareTo(RestXqFunction rxf) {
        if (this.path != null) {
            return this.path.compareTo(rxf.path);
        }
        if (this.error != null) {
            return this.error.compareTo(rxf.error);
        }
        return this.permission.compareTo(rxf.permission);
    }

    QNm checkVariable(String tmp, boolean ... declared) throws QueryException {
        Matcher m = TEMPLATE.matcher(tmp);
        if (!m.find()) {
            throw this.error("Invalid path template: \"%\".", new Object[]{tmp});
        }
        byte[] vn = Token.token((String)m.group(1));
        if (!XMLToken.isQName((byte[])vn)) {
            throw this.error("Invalid variable name: $%.", new Object[]{vn});
        }
        QNm name = new QNm(vn);
        return this.checkVariable(name, (Type)AtomType.ITEM, declared);
    }

    private QNm checkVariable(QNm name, Type type, boolean[] declared) throws QueryException {
        if (name.hasPrefix()) {
            name.uri(this.function.sc.ns.uri(name.prefix()));
        }
        int p = -1;
        Var[] params = this.function.params;
        int pl = params.length;
        while (++p < pl && !params[p].name.eq(name)) {
        }
        if (p == params.length) {
            throw this.error("Variable $% is not specified as argument.", new Object[]{name.string()});
        }
        if (declared[p]) {
            throw this.error("Variable $% is specified more than once.", new Object[]{name.string()});
        }
        SeqType st = params[p].declaredType();
        if (params[p].checksType() && !st.type.instanceOf(type)) {
            throw this.error("Variable $% must inherit from %.", new Object[]{name.string(), type});
        }
        declared[p] = true;
        return name;
    }

    private boolean consumes(HTTPConnection conn) {
        if (this.consumes.isEmpty()) {
            return true;
        }
        MediaType type = conn.contentType();
        if (type.type().isEmpty()) {
            return true;
        }
        for (MediaType consume : this.consumes) {
            if (!consume.matches(type)) continue;
            return true;
        }
        return false;
    }

    private boolean produces(HTTPConnection conn) {
        if (this.produces.isEmpty()) {
            return true;
        }
        for (MediaType accept : conn.accepts()) {
            for (MediaType produce : this.produces) {
                if (!produce.matches(accept)) continue;
                return true;
            }
        }
        return false;
    }

    private void bind(RestXqParam rxp, Expr[] args, Value value, QueryContext qc) throws QueryException {
        this.bind(rxp.var, args, value == null || value.isEmpty() ? rxp.value : value, qc);
    }

    private void bind(QNm name, Expr[] args, Value value, QueryContext qc) throws QueryException {
        if (value == null) {
            return;
        }
        for (Var var : this.function.params) {
            if (!var.name.eq(name)) continue;
            SeqType decl = var.declaredType();
            Value val = value.seqType().instanceOf(decl) ? value : decl.cast(value, qc, this.function.sc, null);
            args[p] = var.checkType(val, qc, false);
            break;
        }
    }

    static String toString(Item item) {
        return ((Str)item).toJava();
    }

    private static void strings(Ann ann, ArrayList<MediaType> list) {
        for (Item item : ann.args()) {
            list.add(new MediaType(RestXqFunction.toString((Item)item)));
        }
    }

    private RestXqParam param(Ann ann, boolean ... declared) throws QueryException {
        Item[] args = ann.args();
        String name = RestXqFunction.toString((Item)args[0]);
        QNm var = this.checkVariable(RestXqFunction.toString((Item)args[1]), declared);
        int al = args.length;
        ItemList items = new ItemList(al - 2);
        for (int a = 2; a < al; ++a) {
            items.add((Object)args[a]);
        }
        return new RestXqParam(var, name, items.value());
    }

    private void error(Ann ann) throws QueryException {
        if (this.error == null) {
            this.error = new RestXqError();
        }
        NameTest last = this.error.get(0);
        for (Item arg : ann.args()) {
            Test.Kind kind;
            String err = RestXqFunction.toString((Item)arg);
            QNm qnm = null;
            if (err.equals("*")) {
                kind = Test.Kind.WILDCARD;
            } else if (err.startsWith("*:")) {
                byte[] local = Token.token((String)err.substring(2));
                if (!XMLToken.isNCName((byte[])local)) {
                    throw this.error("Invalid error code: %.", new Object[]{err});
                }
                qnm = new QNm(local);
                kind = Test.Kind.NAME;
            } else if (err.endsWith(":*")) {
                byte[] prefix = Token.token((String)err.substring(0, err.length() - 2));
                if (!XMLToken.isNCName((byte[])prefix)) {
                    throw this.error("Invalid error code: %.", new Object[]{err});
                }
                qnm = new QNm(Token.concat((byte[])prefix, (byte[])Token.COLON), this.function.sc);
                kind = Test.Kind.URI;
            } else {
                Matcher m = EQNAME.matcher(err);
                if (m.matches()) {
                    byte[] uri = Token.token((String)m.group(1));
                    byte[] local = Token.token((String)m.group(2));
                    if (local.length == 1 && local[0] == 42) {
                        qnm = new QNm(Token.COLON, uri);
                        kind = Test.Kind.URI;
                    } else {
                        if (!XMLToken.isNCName((byte[])local) || !Uri.uri((byte[])uri).isValid()) {
                            throw this.error("Invalid error code: %.", new Object[]{err});
                        }
                        qnm = new QNm(local, uri);
                        kind = Test.Kind.URI_NAME;
                    }
                } else {
                    byte[] nm = Token.token((String)err);
                    if (!XMLToken.isQName((byte[])nm)) {
                        throw this.error("Invalid error code: %.", new Object[]{err});
                    }
                    qnm = new QNm(nm, this.function.sc);
                    kind = Test.Kind.URI_NAME;
                }
            }
            if (qnm != null && qnm.hasPrefix() && !qnm.hasURI()) {
                throw this.error("No namespace declared for '%'.", new Object[]{qnm});
            }
            NameTest test = new NameTest(qnm, kind, false, null);
            if (last != null && last.kind != kind) {
                throw this.error("Errors must be of the same priority (\"%\" vs \"%\").", new Object[]{last, test});
            }
            if (!this.error.add(test)) {
                throw this.error("The same error has been specified twice: \"%\".", new Object[]{last});
            }
            last = test;
        }
    }
}

