/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.XQuery;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTSession;
import org.basex.query.value.type.NodeType;
import org.basex.util.options.Options;

class RESTQuery
extends RESTCmd {
    private final Map<String, String[]> vars;
    private final String value;

    RESTQuery(RESTSession session, Map<String, String[]> vars, String value) {
        super(session);
        this.vars = vars;
        this.value = value;
    }

    protected void run0() throws IOException {
        this.query();
    }

    private void query() throws IOException {
        HTTPConnection conn = this.session.conn;
        this.context.options.set(MainOptions.SERIALIZER, (Options)conn.sopts());
        conn.initResponse();
        for (Command cmd : this.session) {
            if (cmd instanceof XQuery) {
                XQuery xq = (XQuery)cmd;
                if (this.value != null) {
                    xq.bind(null, this.value, NodeType.DOC.toString());
                }
                xq.http((Object)conn);
                this.vars.forEach((key, val) -> {
                    if (((String[])val).length == 2) {
                        xq.bind(key, val[0], val[1]);
                    }
                    if (((String[])val).length == 1) {
                        xq.bind(key, val[0]);
                    }
                });
                conn.sopts().assign(xq.parameters(this.context));
                conn.initResponse();
            }
            this.run(cmd, (OutputStream)conn.res.getOutputStream());
        }
    }

    static RESTQuery get(RESTSession session, String query, Map<String, String[]> vars, String val) throws IOException {
        String uri = session.conn.context.soptions.get(StaticOptions.WEBPATH);
        session.add(new XQuery(query).baseURI(uri));
        return new RESTQuery(session, vars, val);
    }
}

