/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTCommand;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTRetrieve;
import org.basex.http.rest.RESTRun;
import org.basex.http.rest.RESTSession;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.Strings;

final class RESTGet {
    private RESTGet() {
    }

    public static RESTCmd get(RESTSession session) throws IOException {
        HashMap<String, String[]> vars = new HashMap<String, String[]>();
        String op = null;
        String input = null;
        String value = null;
        HTTPConnection conn = session.conn;
        SerializerOptions sopts = conn.sopts();
        for (Map.Entry param : conn.params.stringMap().entrySet()) {
            String key = (String)param.getKey();
            String[] vals = (String[])param.getValue();
            String val = vals[0];
            if (Strings.eqic((String)key, (String[])new String[]{"command", "query", "run"})) {
                if (op != null || vals.length > 1) {
                    throw HTTPCode.ONEOP.get(new Object[0]);
                }
                op = key;
                input = val;
                continue;
            }
            if (key.equalsIgnoreCase("context")) {
                value = val;
                continue;
            }
            if (sopts.option(key) != null) {
                for (String v : vals) {
                    sopts.assign(key, v);
                }
                continue;
            }
            if (RESTCmd.parseOption((RESTSession)session, param, (boolean)false)) continue;
            vars.put(key, new String[]{val});
        }
        if (op == null) {
            return RESTRetrieve.get((RESTSession)session);
        }
        if (op.equals("query")) {
            return RESTQuery.get((RESTSession)session, input, vars, value);
        }
        if (op.equals("run")) {
            return RESTRun.get((RESTSession)session, input, vars, value);
        }
        return RESTCommand.get((RESTSession)session, input);
    }
}

