/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.jobs.Job;
import org.basex.core.locks.LockList;
import org.basex.core.locks.Locks;
import org.basex.core.users.Perm;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPException;
import org.basex.http.rest.RESTSession;
import org.basex.io.out.ArrayOutput;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class RESTCmd
extends Command {
    final RESTSession session;
    HTTPCode code;

    RESTCmd(RESTSession session) {
        super(Perm.NONE, new String[0]);
        this.session = session;
        this.jc().type("REST");
    }

    public void addLocks() {
        Locks locks = this.jc().locks;
        LockList reads = locks.reads;
        LockList writes = locks.writes;
        for (Command cmd : this.session) {
            cmd.addLocks();
            Locks cmdLocks = cmd.jc().locks;
            if (cmdLocks.writes.contains("%CONTEXT")) {
                writes.add(reads);
            }
            reads.add(cmdLocks.reads);
            writes.add(cmdLocks.writes);
        }
    }

    public boolean updating(Context ctx) {
        for (Command cmd : this.session) {
            this.updating |= cmd.updating(ctx);
        }
        return this.updating;
    }

    protected final boolean run() {
        try {
            this.run0();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = this.error(ex.getMessage(), new Object[0]);
            return bl;
        }
        finally {
            Close.close((Context)this.context);
        }
    }

    protected abstract void run0() throws IOException;

    final String run(Command cmd) throws HTTPException {
        ArrayOutput ao = new ArrayOutput();
        this.run(cmd, (OutputStream)ao);
        return ao.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void run(Command cmd, OutputStream os) throws HTTPException {
        try {
            boolean ok = ((Command)this.pushJob((Job)cmd)).run(this.context, os);
            String info = cmd.info();
            this.error(info, new Object[0]);
            if (!ok) {
                if (cmd instanceof Open) {
                    this.code = HTTPCode.NOT_FOUND_X;
                }
                throw HTTPCode.BAD_REQUEST_X.get(new Object[]{info});
            }
        }
        finally {
            this.popJob();
        }
    }

    static void list(Table table, FElem root, QNm header, int skip) {
        for (TokenList list : table.contents) {
            FElem elem = new FElem(header);
            int ll = list.size() - skip;
            for (int l = 1; l < ll; ++l) {
                elem.add(new QNm(Token.lc((byte[])((byte[])table.header.get(l)))), (byte[])list.get(l));
            }
            elem.add((byte[])list.get(0));
            root.add((ANode)elem);
        }
    }

    static void parseOptions(RESTSession session) throws IOException {
        for (Map.Entry param : session.conn.params.stringMap().entrySet()) {
            RESTCmd.parseOption((RESTSession)session, param, (boolean)true);
        }
    }

    static boolean parseOption(RESTSession session, Map.Entry<String, String[]> param, boolean force) throws BaseXException {
        boolean found;
        MainOptions options = session.conn.context.options;
        String key = param.getKey().toUpperCase(Locale.ENGLISH);
        boolean bl = found = options.option(key) != null;
        if (found || force) {
            options.assign(key, param.getValue()[0]);
        }
        return found;
    }
}

