/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.JobException;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPException;
import org.basex.query.QueryException;
import org.basex.server.LoginException;
import org.basex.util.Prop;
import org.basex.util.Util;

public abstract class BaseXServlet
extends HttpServlet {
    String user;
    StaticOptions.AuthMethod auth;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            HTTPContext.init((ServletContext)config.getServletContext());
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String key = ((String)en.nextElement()).toLowerCase(Locale.ENGLISH);
                String val = config.getInitParameter(key);
                if (key.startsWith("org.basex.")) {
                    key = key.substring("org.basex.".length());
                }
                if (key.equalsIgnoreCase(StaticOptions.USER.name())) {
                    this.user = val;
                    continue;
                }
                if (!key.equalsIgnoreCase(StaticOptions.AUTHMETHOD.name())) continue;
                this.auth = StaticOptions.AuthMethod.valueOf((String)val);
            }
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HTTPConnection conn = new HTTPConnection(req, res, this);
        try {
            conn.authenticate();
            this.run(conn);
            conn.log(200, "");
        }
        catch (HTTPException ex) {
            conn.error(ex.getStatus(), Util.message((Throwable)ex));
        }
        catch (LoginException ex) {
            conn.error(401, Util.message((Throwable)ex));
        }
        catch (IOException | QueryException ex) {
            conn.error(400, Util.message((Throwable)ex));
        }
        catch (JobException ex) {
            conn.stop(ex);
        }
        catch (Exception ex) {
            String msg = Util.bug((Throwable)ex);
            Util.errln((Object)msg, (Object[])new Object[0]);
            conn.error(500, Util.info((Object)"Unexpected error: %", (Object[])new Object[]{msg}));
        }
        finally {
            if (Prop.debug) {
                Util.outln((Object)("_ REQUEST _________________________________" + Prop.NL + req), (Object[])new Object[0]);
                Enumeration en = req.getHeaderNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Util.outln((Object)("- " + key + ": " + req.getHeader(key)), (Object[])new Object[0]);
                }
                Util.out((Object)("_ RESPONSE ________________________________" + Prop.NL + res), (Object[])new Object[0]);
            }
        }
    }

    protected abstract void run(HTTPConnection var1) throws Exception;

    public String username(HTTPConnection http) {
        return http.context.user().name();
    }
}

