/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.similarity;

import org.basex.util.Token;
import org.basex.util.TokenParser;
import org.basex.util.list.IntList;

public final class Soundex {
    private static final int[] MAPPING = new TokenParser(Token.token("01230120022455012623010202")).toArray();

    private Soundex() {
    }

    public static int[] encode(int[] cps) {
        IntList tmp = new IntList(cps.length);
        for (int cp : cps) {
            int c = Token.uc(cp);
            if (c < 65 || c > 90) continue;
            tmp.add(c);
        }
        int[] out = new int[]{48, 48, 48, 48};
        int[] in = tmp.finish();
        int is = in.length;
        if (is > 0) {
            out[0] = in[0];
            int op = 1;
            int ip = 0;
            int lastCode = Soundex.map(in, ip++, MAPPING);
            while (ip < is && op < 4) {
                int code;
                if ((code = Soundex.map(in, ip++, MAPPING)) == 0) continue;
                if (code != 48 && code != lastCode) {
                    out[op++] = code;
                }
                lastCode = code;
            }
        }
        return out;
    }

    private static int map(int[] cps, int index, int[] mapping) {
        int ppc;
        int pc;
        int c = mapping[cps[index] - 65];
        if (!(index <= 1 || c == 48 || (pc = cps[index - 1]) != 72 && pc != 87 || (ppc = cps[index - 2]) != 72 && ppc != 87 && mapping[ppc - 65] != c)) {
            return 0;
        }
        return c;
    }
}

