/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.ObjectList;

public final class TokenList
extends ObjectList<byte[], TokenList> {
    public TokenList() {
        this(8);
    }

    public TokenList(int capacity) {
        super((E[])new byte[capacity][]);
    }

    public TokenList(double resize) {
        this();
        this.factor = resize;
    }

    public TokenList(TokenSet set) {
        this(set.size());
        for (byte[] e : set) {
            this.add(e);
        }
    }

    public TokenList(byte[] ... elements) {
        super((E[])elements);
        this.size = elements.length;
    }

    @Override
    public TokenList add(long element) {
        this.add(Token.token(element));
        return this;
    }

    @Override
    public TokenList add(String element) {
        this.add(Token.token(element));
        return this;
    }

    @Override
    public boolean eq(byte[] element1, byte[] element2) {
        return Token.eq(element1, element2);
    }

    public String[] toStringArray() {
        int is = this.size;
        byte[][] l = (byte[][])this.list;
        String[] items = new String[is];
        for (int i = 0; i < is; ++i) {
            items[i] = Token.string(l[i]);
        }
        return items;
    }

    public TokenList sort() {
        return this.sort(true);
    }

    public TokenList sort(boolean cs) {
        return this.sort(cs, true);
    }

    public TokenList sort(boolean cs, boolean ascending) {
        return (TokenList)this.sort(cs ? Token.COMP : Token.LC_COMP, ascending);
    }

    protected byte[][] newList(int s) {
        return new byte[s][];
    }
}

