/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public class TokenMap
extends TokenSet {
    private byte[][] values = new byte[8][];

    public final void put(byte[] key, byte[] value) {
        int i = this.put(key);
        this.values[i] = value;
    }

    public final void put(String key, String value) {
        this.put(Token.token(key), Token.token(value));
    }

    public final byte[] get(byte[] key) {
        return key != null ? this.values[this.id(key)] : null;
    }

    @Override
    public int delete(byte[] key) {
        int i = super.delete(key);
        this.values[i] = null;
        return i;
    }

    public final Iterable<byte[]> values() {
        return new ArrayIterator<byte[]>((Object[])this.values, 1, this.size);
    }

    @Override
    public final void clear() {
        Arrays.fill((Object[])this.values, null);
        super.clear();
    }

    @Override
    protected final void rehash(int sz) {
        super.rehash(sz);
        this.values = Array.copyOf(this.values, sz);
    }

    @Override
    public final String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (int i = 1; i < this.size; ++i) {
            if (!tb.isEmpty()) {
                tb.add(", ");
            }
            if (this.keys[i] == null) continue;
            tb.add(this.keys[i]).add(" = ").add(this.values[i]);
        }
        return new TokenBuilder(Util.className(this.getClass())).add(91).add(tb.finish()).add(93).toString();
    }
}

