/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntSet;

public final class IntMap
extends IntSet {
    private int[] values;

    public IntMap() {
        this(8);
    }

    public IntMap(int capacity) {
        super(capacity);
        this.values = new int[this.buckets.length];
        this.values[0] = Integer.MIN_VALUE;
    }

    public int put(int key, int value) {
        int i = this.put(key);
        int v = this.values[i];
        this.values[i] = value;
        return v;
    }

    public int get(int key) {
        return this.values[this.id(key)];
    }

    @Override
    protected void rehash(int sz) {
        super.rehash(sz);
        this.values = Arrays.copyOf(this.values, sz);
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(Util.className(this)).add(91);
        for (int i = 1; i < this.size; ++i) {
            tb.add(Integer.toString(this.keys[i])).add(": ").addExt(this.get(this.keys[i]), new Object[0]);
            if (i >= this.size - 1) continue;
            tb.add(",\n\t");
        }
        return tb.add(93).toString();
    }
}

