/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class InputParser {
    private static final String FOUND = ", found '%'";
    public final String input;
    public final int length;
    public String file;
    public int pos;
    public int mark;

    public InputParser(String input) {
        this.input = input;
        this.length = input.length();
    }

    public final boolean more() {
        return this.pos < this.length;
    }

    public final char curr() {
        int i = this.pos;
        return i < this.length ? this.input.charAt(i) : (char)'\u0000';
    }

    public final boolean curr(int ch) {
        int i = this.pos;
        return i < this.length && ch == this.input.charAt(i);
    }

    protected final void mark() {
        this.mark = this.pos;
    }

    protected final char next() {
        int i = this.pos + 1;
        return i < this.length ? this.input.charAt(i) : (char)'\u0000';
    }

    public final char consume() {
        return this.pos < this.length ? this.input.charAt(this.pos++) : (char)'\u0000';
    }

    public final boolean consume(int ch) {
        int i;
        return (i = this.pos++) < this.length && ch == this.input.charAt(i);
    }

    protected static boolean quote(int ch) {
        return ch == 34 || ch == 39;
    }

    public final boolean consume(String string) {
        int i = this.pos;
        int l = string.length();
        if (i + l > this.length) {
            return false;
        }
        for (int s = 0; s < l; ++s) {
            if (this.input.charAt(i++) == string.charAt(s)) continue;
            return false;
        }
        this.pos = i;
        return true;
    }

    protected final byte[] found() {
        return this.curr() == '\u0000' ? Token.EMPTY : Util.inf(FOUND, Character.valueOf(this.curr()));
    }

    protected final String rest() {
        char ch;
        StringBuilder sb = new StringBuilder();
        int pl = Math.min(this.length, this.pos + 15);
        for (int p = this.pos; p < pl && (ch = this.input.charAt(p)) != '\n'; ++p) {
            sb.append(ch);
        }
        return sb + (pl == this.length ? "" : "...");
    }

    public final InputInfo info() {
        return new InputInfo(this);
    }
}

