/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public final class Atts
extends ElementList {
    private byte[][] nm;
    private byte[][] vl;

    public Atts() {
        this.nm = new byte[1][];
        this.vl = new byte[1][];
    }

    public Atts(byte[] name, byte[] value) {
        this.nm = new byte[][]{name};
        this.vl = new byte[][]{value};
        this.size = 1;
    }

    public Atts add(byte[] name, byte[] value) {
        if (this.size == this.nm.length) {
            int s = Array.newSize(this.size);
            this.nm = Array.copyOf(this.nm, s);
            this.vl = Array.copyOf(this.vl, s);
        }
        this.nm[this.size] = name;
        this.vl[this.size++] = value;
        return this;
    }

    public void delete(int index) {
        Array.move(this.nm, index + 1, -1, --this.size - index);
        Array.move(this.vl, index + 1, -1, this.size - index);
    }

    public boolean contains(byte[] name) {
        return this.get(name) != -1;
    }

    public int get(byte[] name) {
        for (int i = 0; i < this.size; ++i) {
            if (!Token.eq(this.nm[i], name)) continue;
            return i;
        }
        return -1;
    }

    public byte[] name(int index) {
        return this.nm[index];
    }

    public byte[] value(int index) {
        return this.vl[index];
    }

    public byte[] value(byte[] name) {
        int i = this.get(name);
        return i == -1 ? null : this.vl[i];
    }

    public Atts copy() {
        Atts copy = new Atts();
        copy.nm = (byte[][])this.nm.clone();
        copy.vl = (byte[][])this.vl.clone();
        copy.size = this.size;
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Atts)) {
            return false;
        }
        Atts a = (Atts)obj;
        if (this.size != a.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (Token.eq(this.nm[i], a.nm[i]) && Token.eq(this.vl[i], a.vl[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(Util.className(this) + '[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                tb.add(", ");
            }
            tb.add(this.nm[i]).add("=\"").add(this.vl[i]).add("\"");
        }
        return tb.add("]").toString();
    }
}

