/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.var.Var;
import org.basex.util.Prop;
import org.basex.util.Util;

public final class QueryStack {
    private static final int INIT = 8;
    private Value[] stack = new Value[8];
    private Var[] vars = new Var[8];
    private int start;
    private int end;

    public int enterFrame(int size) {
        int e = this.end;
        int ne = e + size;
        this.ensureCapacity(ne);
        int s = this.start;
        this.start = e;
        this.end = ne;
        return s;
    }

    public void reuseFrame(int size) {
        int s = this.start;
        this.ensureCapacity(s + size);
        Value[] stck = this.stack;
        int e = this.end;
        while (--e >= s) {
            stck[e] = null;
        }
        this.end = s + size;
    }

    public void exitFrame(int frame) {
        int sl;
        int len;
        int s = this.start;
        Value[] stck = this.stack;
        int en = this.end;
        while (--en >= s) {
            stck[en] = null;
        }
        this.end = s;
        this.start = frame;
        for (len = sl = stck.length; len > 8 && sl <= len >> 2; len >>= 1) {
        }
        if (len != sl) {
            this.resize(len);
        }
    }

    private void ensureCapacity(int newSize) {
        int sl;
        int len;
        for (len = sl = this.stack.length; newSize > len; len <<= 1) {
        }
        if (len != sl) {
            this.resize(len);
        }
    }

    private void resize(int len) {
        int os = this.end;
        Value[] nst = new Value[len];
        System.arraycopy(this.stack, 0, nst, 0, os);
        this.stack = nst;
        Var[] nvr = new Var[len];
        System.arraycopy(this.vars, 0, nvr, 0, os);
        this.vars = nvr;
    }

    private int pos(Var var) {
        int pos = this.start + var.slot;
        if (pos < this.start || this.end <= pos) {
            throw Util.notExpected(var + " index: " + pos + ", slot: " + var.slot, new Object[0]);
        }
        return pos;
    }

    public Value get(Var var) {
        return this.stack[this.pos(var)];
    }

    public void set(Var var, Value val, QueryContext qc) throws QueryException {
        int pos = this.pos(var);
        this.stack[pos] = var.checkType(val, qc, false);
        this.vars[pos] = var;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("Local Variables:");
        int i = this.end;
        while (--i >= 0) {
            if (this.vars[i] == null) continue;
            sb.append(Prop.NL).append("  $").append(this.vars[i].name).append(" := ").append(this.stack[i]);
            if (i != this.start || i <= 0) continue;
            sb.append(Prop.NL).append("Global Variables:");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Util.className(this)).append('[');
        for (int i = 0; i < this.end; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.stack[i]);
        }
        return sb.append(']').toString();
    }
}

