/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Seq;
import org.basex.util.InputInfo;

final class SubSeq
extends Seq {
    private final Seq sub;
    private final long start;

    SubSeq(Seq sub, long start, long length) {
        super(length, sub.type);
        this.sub = sub;
        this.start = start;
    }

    @Override
    protected Seq subSeq(long offset, long length, QueryContext qc) {
        qc.checkStop();
        return new SubSeq(this.sub, this.start + offset, length);
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return this.copyRemove(pos, qc);
    }

    @Override
    public Value reverse(QueryContext qc) {
        ValueBuilder vb = new ValueBuilder(qc);
        for (long i = 0L; i < this.size; ++i) {
            vb.addFront(this.itemAt(i));
        }
        return vb.value();
    }

    @Override
    public Item itemAt(long pos) {
        return this.sub.itemAt(this.start + pos);
    }

    @Override
    public boolean homogeneous() {
        return this.sub.homogeneous();
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo info) throws QueryException {
        Item fst = this.itemAt(0L);
        if (fst instanceof ANode) {
            return fst;
        }
        throw QueryError.EBV_X.get(info, this);
    }

    @Override
    public void materialize(InputInfo info) throws QueryException {
        for (long i = 0L; i < this.size; ++i) {
            this.itemAt(i).materialize(info);
        }
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo info) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (long i = 0L; i < this.size; ++i) {
            vb.add(this.itemAt(i).atomValue(qc, info));
        }
        return vb.value();
    }

    @Override
    public long atomSize() {
        long sz = 0L;
        int i = 0;
        while ((long)i < this.size) {
            sz += this.itemAt(i).atomSize();
            ++i;
        }
        return sz;
    }
}

