/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;

public final class RangeSeq
extends Seq {
    private final long start;
    public final boolean asc;

    private RangeSeq(long start, long size, boolean asc) {
        super(size, AtomType.ITR);
        this.start = start;
        this.asc = asc;
    }

    public static Value get(long min, long size, boolean asc) {
        return size < 1L ? Empty.SEQ : (size == 1L ? Int.get(min) : new RangeSeq(min, size, asc));
    }

    public long[] range(boolean order) {
        long end = this.asc ? this.start + this.size - 1L : this.start - this.size + 1L;
        return new long[]{order || this.asc ? this.start : end, order || this.asc ? end : this.start};
    }

    @Override
    public Object toJava() {
        long[] obj = new long[(int)this.size];
        int s = 0;
        while ((long)s < this.size) {
            obj[s] = this.start + (long)(this.asc ? s : -s);
            ++s;
        }
        return obj;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo info) throws QueryException {
        throw QueryError.EBV_X.get(info, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeSeq)) {
            return super.equals(obj);
        }
        RangeSeq seq = (RangeSeq)obj;
        return this.start == seq.start && this.size == seq.size && this.asc == seq.asc;
    }

    @Override
    public Item itemAt(long pos) {
        return Int.get(this.start + (this.asc ? pos : -pos));
    }

    @Override
    protected Seq subSeq(long offset, long length, QueryContext qc) {
        return new RangeSeq(this.start + (this.asc ? offset : -offset), length, this.asc);
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return pos == 0L || pos == this.size - 1L ? this.subSeq(pos == 0L ? 0L : 1L, this.size - 1L, qc) : this.copyRemove(pos, qc);
    }

    @Override
    public Value reverse(QueryContext qc) {
        return RangeSeq.get(this.range(true)[1], this.size(), !this.asc);
    }

    @Override
    public void materialize(InputInfo info) {
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo info) {
        return this;
    }

    @Override
    public long atomSize() {
        return this.size;
    }

    @Override
    public boolean homogeneous() {
        return true;
    }

    @Override
    public void plan(FElem plan) {
        long[] range = this.range(true);
        RangeSeq.addPlan(plan, this.planElem("from", range[0], "to", range[1], "size", this.size, "type", this.seqType()), new ExprInfo[0]);
    }

    @Override
    public String description() {
        return "range sequence";
    }

    @Override
    public String toString() {
        long[] range = this.range(false);
        String str = "(" + range[0] + ' ' + "to" + ' ' + range[1] + ")";
        return this.asc ? str : Function.REVERSE.args(' ' + str).substring(1);
    }
}

