/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class BlnSeq
extends NativeSeq {
    private final boolean[] values;

    private BlnSeq(boolean[] values) {
        super(values.length, (Type)AtomType.BLN);
        this.values = values;
    }

    @Override
    public Bln itemAt(long pos) {
        return Bln.get(this.values[(int)pos]);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof BlnSeq ? Arrays.equals(this.values, ((BlnSeq)obj).values) : super.equals(obj));
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        boolean[] tmp = new boolean[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return BlnSeq.get(tmp);
    }

    public boolean[] toJava() {
        return this.values;
    }

    public static Value get(boolean[] values) {
        return values.length == 0 ? Empty.SEQ : (values.length == 1 ? Bln.get(values[0]) : new BlnSeq(values));
    }

    public static Value get(Value[] values, int size) throws QueryException {
        boolean[] tmp = new boolean[size];
        int t = 0;
        for (Value value : values) {
            int vs = (int)value.size();
            if (value instanceof BlnSeq) {
                BlnSeq seq = (BlnSeq)value;
                System.arraycopy(seq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = value.itemAt(v).bool(null);
            }
        }
        return BlnSeq.get(tmp);
    }
}

