/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieList;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

final class TrieBranch
extends TrieNode {
    private final TrieNode[] kids;
    final int used;
    private static final String[] ENDS = new String[]{"|-- ", "|   ", "`-- ", "    "};

    TrieBranch(TrieNode[] kids, int used, int size) {
        super(size);
        this.kids = kids;
        this.used = used;
        assert (this.verify());
    }

    TrieNode[] copyKids() {
        TrieNode[] copy = new TrieNode[32];
        System.arraycopy(this.kids, 0, copy, 0, 32);
        return copy;
    }

    @Override
    TrieNode put(int hs, Item key, Value value, int level, InputInfo info) throws QueryException {
        int rem;
        int bs;
        TrieNode nsub;
        int k = TrieBranch.key(hs, level);
        TrieNode sub = this.kids[k];
        if (sub != null) {
            nsub = sub.put(hs, key, value, level + 1, info);
            if (nsub == sub) {
                return this;
            }
            bs = this.used;
            rem = sub.size;
        } else {
            nsub = new TrieLeaf(hs, key, value);
            bs = this.used | 1 << k;
            rem = 0;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = nsub;
        return new TrieBranch(ks, bs, this.size - rem + nsub.size);
    }

    @Override
    TrieNode delete(int hash, Item key, int level, InputInfo info) throws QueryException {
        int nu;
        int k = TrieBranch.key(hash, level);
        TrieNode sub = this.kids[k];
        if (sub == null) {
            return this;
        }
        TrieNode nsub = sub.delete(hash, key, level + 1, info);
        if (nsub == sub) {
            return this;
        }
        if (nsub == null) {
            TrieNode single;
            nu = this.used ^ 1 << k;
            if (Integer.bitCount(nu) == 1 && !((single = this.kids[Integer.numberOfTrailingZeros(nu)]) instanceof TrieBranch)) {
                return single;
            }
        } else {
            nu = this.used;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = nsub;
        return new TrieBranch(ks, nu, this.size - 1);
    }

    @Override
    Value get(int hash, Item key, int level, InputInfo info) throws QueryException {
        int k = TrieBranch.key(hash, level);
        TrieNode sub = this.kids[k];
        return sub == null ? null : sub.get(hash, key, level + 1, info);
    }

    @Override
    boolean contains(int hash, Item key, int level, InputInfo info) throws QueryException {
        int k = TrieBranch.key(hash, level);
        TrieNode sub = this.kids[k];
        return sub != null && sub.contains(hash, key, level + 1, info);
    }

    @Override
    TrieNode addAll(TrieNode node, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        return node.add(this, level, merge, info, qc);
    }

    @Override
    TrieNode add(TrieLeaf leaf, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        TrieNode kid;
        qc.checkStop();
        int k = TrieBranch.key(leaf.hash, level);
        TrieNode ch = this.kids[k];
        int n = 1;
        if (ch != null) {
            TrieNode ins = ch.add(leaf, level + 1, merge, info, qc);
            if (ins == ch) {
                return this;
            }
            n = ins.size - ch.size;
            kid = ins;
        } else {
            kid = leaf;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = kid;
        return new TrieBranch(ks, this.used | 1 << k, this.size + n);
    }

    @Override
    TrieNode add(TrieList list, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        TrieNode kid;
        qc.checkStop();
        int k = TrieBranch.key(list.hash, level);
        TrieNode ch = this.kids[k];
        int n = list.size;
        if (ch != null) {
            TrieNode ins = ch.add(list, level + 1, merge, info, qc);
            if (ins == ch) {
                return this;
            }
            n = ins.size - ch.size;
            kid = ins;
        } else {
            kid = list;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = kid;
        return new TrieBranch(ks, this.used | 1 << k, this.size + n);
    }

    @Override
    TrieNode add(TrieBranch branch, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        TrieNode[] ch = null;
        int nu = this.used;
        int ns = this.size;
        int kl = this.kids.length;
        for (int k = 0; k < kl; ++k) {
            TrieNode kid;
            TrieNode n = this.kids[k];
            TrieNode ok = branch.kids[k];
            if (ok == null) continue;
            TrieNode trieNode = kid = n == null ? ok : ok.addAll(n, level + 1, merge, info, qc);
            if (kid == n) continue;
            if (ch == null) {
                ch = this.copyKids();
            }
            ch[k] = kid;
            nu |= 1 << k;
            ns += kid.size - (n == null ? 0 : n.size);
        }
        return ch == null ? this : new TrieBranch(ch, nu, ns);
    }

    @Override
    boolean verify() {
        int c = 0;
        for (int i = 0; i < 32; ++i) {
            boolean act;
            boolean bit = (this.used & 1 << i) != 0;
            boolean bl = act = this.kids[i] != null;
            if (bit ^ act) {
                return false;
            }
            if (!act) continue;
            c += this.kids[i].size;
        }
        return c == this.size;
    }

    @Override
    void keys(ItemList ks) {
        for (TrieNode nd : this.kids) {
            if (nd == null) continue;
            nd.keys(ks);
        }
    }

    @Override
    void values(ValueBuilder vs) {
        for (TrieNode nd : this.kids) {
            if (nd == null) continue;
            nd.values(vs);
        }
    }

    @Override
    void materialize(InputInfo info) throws QueryException {
        for (TrieNode nd : this.kids) {
            if (nd == null) continue;
            nd.materialize(info);
        }
    }

    @Override
    void forEach(ValueBuilder vb, FItem func, QueryContext qc, InputInfo info) throws QueryException {
        for (TrieNode nd : this.kids) {
            if (nd == null) continue;
            nd.forEach(vb, func, qc, info);
        }
    }

    @Override
    boolean instanceOf(AtomType kt, SeqType dt) {
        for (TrieNode k : this.kids) {
            if (k == null || k.instanceOf(kt, dt)) continue;
            return false;
        }
        return true;
    }

    @Override
    int hash(InputInfo info) throws QueryException {
        int hash = 0;
        for (TrieNode ch : this.kids) {
            if (ch == null) continue;
            hash = 31 * hash + ch.hash(info);
        }
        return hash;
    }

    @Override
    boolean deep(InputInfo info, TrieNode node, Collation coll) throws QueryException {
        if (!(node instanceof TrieBranch)) {
            return false;
        }
        TrieBranch ob = (TrieBranch)node;
        if (this.used != ob.used) {
            return false;
        }
        for (int i = 0; i < 32; ++i) {
            if (this.kids[i] == null || this.kids[i].deep(info, ob.kids[i], coll)) continue;
            return false;
        }
        return true;
    }

    @Override
    StringBuilder append(StringBuilder sb, String indent) {
        int s = Integer.bitCount(this.used);
        int i = 0;
        int j = 0;
        while (i < s) {
            while ((this.used & 1 << j) == 0) {
                ++j;
            }
            int e = i == s - 1 ? 2 : 0;
            sb.append(indent).append(ENDS[e]).append(String.format("%x", j)).append('\n');
            this.kids[j].append(sb, indent + ENDS[e + 1]);
            ++i;
            ++j;
        }
        return sb;
    }

    @Override
    StringBuilder append(StringBuilder sb) {
        for (int i = 0; i < 32 && TrieBranch.more(sb); ++i) {
            if (this.kids[i] == null) continue;
            this.kids[i].append(sb);
        }
        return sb;
    }
}

