/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.list;

import java.util.Iterator;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.list.ObjectList;

public final class ANodeBuilder
extends ObjectList<ANode, ANodeBuilder> {
    private State state = State.BUILD;
    private boolean dbnodes;

    public ANodeBuilder() {
        super(new ANode[1]);
    }

    @Override
    public ANodeBuilder add(ANode element) {
        if (this.size != 0 && this.state != State.SORT) {
            int d = element.diff(((ANode[])this.list)[this.size - 1]);
            if (d == 0) {
                return this;
            }
            if (d < 0) {
                this.state = State.SORT;
                this.dbnodes = false;
            }
        }
        return (ANodeBuilder)((Object)super.add(element));
    }

    @Override
    public Iterator<ANode> iterator() {
        this.check();
        return super.iterator();
    }

    public BasicNodeIter iter() {
        this.check();
        return new BasicNodeIter(){
            int pos;

            @Override
            public ANode next() {
                return this.pos < ANodeBuilder.this.size ? ((ANode[])ANodeBuilder.this.list)[this.pos++] : null;
            }

            @Override
            public ANode get(long i) {
                return ((ANode[])ANodeBuilder.this.list)[(int)i];
            }

            @Override
            public long size() {
                return ANodeBuilder.this.size;
            }

            @Override
            public Value value(QueryContext qc) {
                return ANodeBuilder.this.value();
            }
        };
    }

    public Value value() {
        return ValueBuilder.value((Item[])this.list, this.size, NodeType.NOD);
    }

    public void check() {
        Data data;
        this.sort();
        int s = this.size;
        ANode[] nodes = (ANode[])this.list;
        Data data2 = data = s > 0 ? nodes[0].data() : null;
        if (data == null) {
            return;
        }
        for (int l = 1; l < s; ++l) {
            if (data == nodes[l].data()) continue;
            return;
        }
        this.dbnodes = true;
    }

    public boolean dbnodes() {
        this.check();
        return this.dbnodes;
    }

    @Override
    public boolean delete(ANode node) {
        if (this.dbnodes) {
            int p = this.binarySearch((DBNode)node, 0, this.size);
            if (p < 0) {
                return false;
            }
            this.remove(p);
            return true;
        }
        return super.delete(node);
    }

    @Override
    public boolean contains(ANode node) {
        return this.dbnodes ? node instanceof DBNode && this.binarySearch((DBNode)node, 0, this.size) > -1 : super.contains(node);
    }

    @Override
    public boolean eq(ANode node1, ANode node2) {
        return node1.is(node2);
    }

    public int binarySearch(DBNode node, int start, int length) {
        if (this.size == 0 || node.data() != ((ANode[])this.list)[0].data()) {
            return -start - 1;
        }
        int l = start;
        int r = start + length - 1;
        ANode[] nodes = (ANode[])this.list;
        while (l <= r) {
            int npre;
            int m = l + r >>> 1;
            int mpre = ((DBNode)nodes[m]).pre();
            if (mpre == (npre = node.pre())) {
                return m;
            }
            if (mpre < npre) {
                l = m + 1;
                continue;
            }
            r = m - 1;
        }
        return -(l + 1);
    }

    private void sort() {
        if (this.state == State.SORTED) {
            return;
        }
        int s = this.size;
        if (s > 1) {
            if (this.state == State.SORT) {
                this.sort(0, s);
            }
            int i = 1;
            ANode[] nodes = (ANode[])this.list;
            for (int j = 1; j < s; ++j) {
                while (j < s && nodes[i - 1].is(nodes[j])) {
                    ++j;
                }
                if (j >= s) continue;
                nodes[i++] = nodes[j];
            }
            this.size = i;
        }
        this.state = State.SORTED;
    }

    private void sort(int s, int e) {
        int c;
        int a;
        ANode[] nodes = (ANode[])this.list;
        if (e < 7) {
            for (int i = s; i < e + s; ++i) {
                for (int j = i; j > s && nodes[j - 1].diff(nodes[j]) > 0; --j) {
                    this.s(j, j - 1);
                }
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        ANode v = nodes[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            int h;
            if (b <= c && (h = nodes[b].diff(v)) <= 0) {
                if (h == 0) {
                    this.s(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (h = nodes[c].diff(v)) >= 0) {
                if (h == 0) {
                    this.s(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k);
        k = b - a;
        if (k > 1) {
            this.sort(s, k);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k);
        }
    }

    private void s(int a, int b, int n) {
        for (int i = 0; i < n; ++i) {
            this.s(a + i, b + i);
        }
    }

    private int m(int a, int b, int c) {
        ANode[] nodes = (ANode[])this.list;
        ANode nodeA = nodes[a];
        ANode nodeB = nodes[b];
        ANode nodeC = nodes[c];
        return nodeA.diff(nodeB) < 0 ? (nodeB.diff(nodeC) < 0 ? b : (nodeA.diff(nodeC) < 0 ? c : a)) : (nodeB.diff(nodeC) > 0 ? b : (nodeA.diff(nodeC) > 0 ? c : a));
    }

    private void s(int a, int b) {
        ANode[] nodes = (ANode[])this.list;
        ANode tmp = nodes[a];
        nodes[a] = nodes[b];
        nodes[b] = tmp;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof ANodeBuilder && super.equals(obj);
    }

    protected ANode[] newList(int s) {
        return new ANode[s];
    }

    private static enum State {
        BUILD,
        SORT,
        SORTED;

    }
}

