/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.util.format.Formatter;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

final class FormatterEN
extends Formatter {
    private static final byte[][] WORDS = Token.tokens("Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen");
    private static final byte[][] WORDS10 = Token.tokens("", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety");
    private static final byte[][] WORDS100 = Token.tokens("Hundred", "Thousand", "Million", "Billion", "Trillion", "Quadrillion", "Quintillion");
    private static final long[] UNITS100 = new long[]{100L, 1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final byte[][] ORDINALS = Token.tokens("Zeroth", "First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth");
    private static final byte[][] ORDINALS10 = Token.tokens("", "Tenth", "Twentieth", "Thirtieth", "Fortieth", "Fiftieth", "Sixtieth", "Seventieth", "Eightieth", "Ninetieth");
    private static final byte[][][] DAYS = new byte[][][]{Token.tokens("M", "Mon", "Monday"), Token.tokens("Tu", "Tue", "Tues", "Tuesday"), Token.tokens("W", "Wed", "Weds", "Wednesday"), Token.tokens("Th", "Thu", "Thur", "Thurs", "Thursday"), Token.tokens("F", "Fri", "Friday"), Token.tokens("Sa", "Sat", "Saturday"), Token.tokens("Su", "Sun", "Sunday")};
    private static final byte[][] MONTHS = Token.tokens("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
    private static final byte[][] AMPM = Token.tokens("Am", "Pm");
    private static final byte[] AND = Token.token("and");
    private static final byte[][] ORDSUFFIX = Token.tokens("st", "nd", "rd", "th");
    private static final byte[][] ERAS = Token.tokens("Bc", "Ad");

    FormatterEN() {
    }

    @Override
    public byte[] word(long n, byte[] ord) {
        TokenBuilder tb = new TokenBuilder();
        FormatterEN.word(tb, n, ord != null);
        return tb.finish();
    }

    @Override
    public byte[] ordinal(long n, byte[] ord) {
        if (ord == null) {
            return Token.EMPTY;
        }
        int f = (int)(n % 10L);
        return ORDSUFFIX[f > 0 && f < 4 && n % 100L / 10L != 1L ? f - 1 : 3];
    }

    @Override
    public byte[] month(int n, int min, int max) {
        TokenBuilder tb = new TokenBuilder();
        tb.add(Token.substring(MONTHS[n], 0, Math.max(3, max)));
        while (tb.size() < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    @Override
    public byte[] day(int n, int min, int max) {
        TokenBuilder tb = new TokenBuilder();
        byte[][] formats = DAYS[n];
        int f = formats.length;
        while (--f > 0 && max < formats[f].length) {
        }
        tb.add(formats[f]);
        while (tb.size() < min) {
            tb.add(32);
        }
        return tb.finish();
    }

    @Override
    public byte[] ampm(boolean am) {
        return AMPM[am ? 0 : 1];
    }

    @Override
    public byte[] calendar() {
        return ERAS[1];
    }

    @Override
    public byte[] era(long year) {
        return ERAS[year <= 0L ? 0 : 1];
    }

    private static void word(TokenBuilder tb, long number, boolean ordinal) {
        if (number != 0L || tb.isEmpty()) {
            if (number < 20L) {
                tb.add((ordinal ? ORDINALS : WORDS)[(int)number]);
            } else if (number < 100L) {
                int r = (int)(number % 10L);
                if (r == 0) {
                    tb.add((ordinal ? ORDINALS10 : WORDS10)[(int)number / 10]);
                } else {
                    tb.add(WORDS10[(int)number / 10]).add(32);
                    tb.add((ordinal ? ORDINALS : WORDS)[r]);
                }
            } else {
                for (int w = WORDS100.length - 1; w >= 0; --w) {
                    long f = UNITS100[w];
                    if (number < f) continue;
                    FormatterEN.word(tb, number / f, false);
                    tb.add(32).add(WORDS100[w]);
                    long r = number % f;
                    if (r == 0L) {
                        if (ordinal) {
                            tb.add(ORDSUFFIX[3]);
                        }
                    } else {
                        tb.add(32);
                        if (r < 100L) {
                            tb.add(AND).add(32);
                        }
                    }
                    FormatterEN.word(tb, r, ordinal);
                    break;
                }
            }
        }
    }
}

