/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.data.Data;
import org.basex.util.Util;

public final class IndexCosts
implements Comparable<IndexCosts> {
    public static final IndexCosts ENFORCE = new IndexCosts(-1);
    public static final IndexCosts ZERO = new IndexCosts(0);
    private final int results;

    private IndexCosts(int results) {
        this.results = results;
    }

    public static IndexCosts get(int results) {
        if (results < 0) {
            throw Util.notExpected("Costs cannot be negative.", new Object[0]);
        }
        return results == 0 ? ZERO : new IndexCosts(results);
    }

    public static IndexCosts add(IndexCosts ic1, IndexCosts ic2) {
        if (ic1 == ENFORCE || ic2 == ENFORCE) {
            return ENFORCE;
        }
        int r = (ic1 == null ? 0 : ic1.results) + (ic2 == null ? 0 : ic2.results);
        return IndexCosts.get(r >= 0 ? r : Integer.MAX_VALUE);
    }

    public int results() {
        return this.results;
    }

    public boolean tooExpensive(Data data) {
        return this != ENFORCE && this.results > data.meta.size;
    }

    @Override
    public int compareTo(IndexCosts ic) {
        return this == ENFORCE ? (ic == ENFORCE ? 0 : -1) : (ic == ENFORCE ? 1 : this.results - ic.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Util.className(this)).append('[');
        if (this == ENFORCE) {
            sb.append("always");
        } else {
            sb.append(this.results);
        }
        return sb.append(']').toString();
    }
}

