/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import org.basex.io.IO;
import org.basex.util.Util;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class ErrorInfo {
    final String message;
    final String level;
    String url;
    int line = Integer.MIN_VALUE;
    int column = Integer.MIN_VALUE;

    ErrorInfo(SAXException ex, String level, IO schema) {
        this.level = level;
        String m = ex.getMessage();
        Throwable e = ex;
        if (m.contains("Exception:") && (e = Util.rootException(e)) instanceof SAXException) {
            m = e.getLocalizedMessage();
        }
        if (ex instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)ex;
            String id = se.getSystemId();
            if (id != null) {
                IO io = IO.get(id);
                if (schema == null || !io.isDir() && !schema.equals(io)) {
                    this.url = id;
                }
            }
            this.line = se.getLineNumber();
            this.column = se.getColumnNumber();
        }
        this.message = m;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.url != null) {
            sb.append(this.url).append(", ");
        }
        if (this.line != Integer.MIN_VALUE) {
            sb.append(this.line).append(':').append(this.column).append(": ");
        }
        return sb.append(this.message).toString();
    }
}

