/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLXML;
import java.sql.Statement;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.sql.SqlFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;

public class SqlExecute
extends SqlFn {
    private static final QNm Q_ROW = new QNm(QueryText.SQL_PREFIX, "row", QueryText.SQL_URI);
    private static final QNm Q_COLUMN = new QNm(QueryText.SQL_PREFIX, "column", QueryText.SQL_URI);
    private static final String NAME = "name";

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        Connection conn = this.connection(qc);
        String query = Token.string(this.toToken(this.exprs[1], qc));
        StatementOptions options = this.toOptions(2, new StatementOptions(), qc);
        try {
            Statement stmt = conn.createStatement();
            stmt.setQueryTimeout(options.get(StatementOptions.TIMEOUT));
            return this.iter(stmt, true, stmt.execute(query));
        }
        catch (SQLTimeoutException ex) {
            throw QueryError.SQL_TIMEOUT_X.get(this.info, ex);
        }
        catch (SQLException ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
    }

    final Iter iter(final Statement stmt, final boolean close, boolean result) throws QueryException {
        try {
            if (!result) {
                return Int.get(stmt.getUpdateCount()).iter();
            }
            final ResultSet rs = stmt.getResultSet();
            final ResultSetMetaData md = rs.getMetaData();
            final int cols = md.getColumnCount();
            return new Iter(){

                @Override
                public Item next() throws QueryException {
                    try {
                        if (!rs.next()) {
                            rs.close();
                            if (close) {
                                stmt.close();
                            }
                            return null;
                        }
                        FElem row = new FElem(Q_ROW);
                        for (int c = 1; c <= cols; ++c) {
                            String name = md.getColumnLabel(c);
                            Object value = rs.getObject(c);
                            if (value == null) continue;
                            FElem col = new FElem(Q_COLUMN).add(SqlExecute.NAME, name);
                            row.add(col);
                            if (value instanceof SQLXML) {
                                String xml = ((SQLXML)value).getString();
                                try {
                                    col.add(new DBNode(new IOContent(xml)).children().next());
                                }
                                catch (IOException ex) {
                                    Util.debug(ex);
                                    col.add(xml);
                                }
                                continue;
                            }
                            if (value instanceof Clob) {
                                Clob clob = (Clob)value;
                                col.add(clob.getSubString(1L, (int)clob.length()));
                                continue;
                            }
                            col.add(value.toString());
                        }
                        return row;
                    }
                    catch (SQLException ex) {
                        throw QueryError.SQL_ERROR_X.get(SqlExecute.this.info, ex);
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
    }

    public static class StatementOptions
    extends Options {
        public static final NumberOption TIMEOUT = new NumberOption("timeout", 0);
    }
}

