/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.Map;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class InspectStaticContext
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        StaticContext sctx;
        Item func = this.exprs[0].item(qc, this.info);
        String name = Token.string(this.toToken(this.exprs[1], qc));
        if (func == null) {
            sctx = this.sc;
        } else {
            if (!((func = this.toFunc(func, qc)) instanceof FuncItem)) {
                throw QueryError.INVFUNCITEM_X_X.get(this.info, func.type, func);
            }
            sctx = ((FuncItem)func).sc;
        }
        switch (name) {
            case "base-uri": {
                return sctx.baseURI();
            }
            case "namespaces": {
                int n;
                Map map = Map.EMPTY;
                Atts nsp = sctx.ns.ns;
                int ns = nsp.size();
                for (n = 0; n < ns; ++n) {
                    map = map.put(Str.get(nsp.name(n)), Str.get(nsp.value(n)), this.info);
                }
                nsp = NSGlobal.NS;
                ns = nsp.size();
                for (n = 0; n < ns; ++n) {
                    Str key = Str.get(nsp.name(n));
                    if (map.contains(key, this.info)) continue;
                    map = map.put(key, Str.get(nsp.value(n)), this.info);
                }
                return map;
            }
            case "element-namespace": {
                return sctx.elemNS == null ? Empty.SEQ : Uri.uri(sctx.elemNS);
            }
            case "function-namespace": {
                return sctx.funcNS == null ? Empty.SEQ : Uri.uri(sctx.funcNS);
            }
            case "collation": {
                return Uri.uri(sctx.collation == null ? QueryText.COLLATION_URI : sctx.collation.uri());
            }
            case "ordering": {
                return Str.get(sctx.ordered ? "ordered" : "unordered");
            }
            case "construction": {
                return Str.get(sctx.strip ? "strip" : "preserve");
            }
            case "default-order-empty": {
                return Str.get(sctx.orderGreatest ? "greatest" : "least");
            }
            case "boundary-space": {
                return Str.get(sctx.spaces ? "preserve" : "strip");
            }
            case "copy-namespaces": {
                TokenList sl = new TokenList(2);
                sl.add(sctx.preserveNS ? "preserve" : "no-preserve");
                sl.add(sctx.inheritNS ? "inherit" : "no-inherit");
                return StrSeq.get(sl);
            }
            case "decimal-formats": {
                Map map = Map.EMPTY;
                sctx.decFormat(Token.EMPTY);
                for (byte[] format : sctx.decFormats) {
                    DecFormatter df = sctx.decFormats.get(format);
                    map = map.put(Str.get(format), Map.EMPTY.put(Str.get("decimal-separator"), Str.get(InspectStaticContext.token(df.decimal)), this.info).put(Str.get("exponent-separator"), Str.get(InspectStaticContext.token(df.exponent)), this.info).put(Str.get("grouping-separator"), Str.get(InspectStaticContext.token(df.grouping)), this.info).put(Str.get("percent"), Str.get(InspectStaticContext.token(df.percent)), this.info).put(Str.get("per-mille"), Str.get(InspectStaticContext.token(df.permille)), this.info).put(Str.get("zero-digit"), Str.get(InspectStaticContext.token(df.zero)), this.info).put(Str.get("digit"), Str.get(InspectStaticContext.token(df.optional)), this.info).put(Str.get("pattern-separator"), Str.get(InspectStaticContext.token(df.pattern)), this.info).put(Str.get("infinity"), Str.get(df.inf), this.info).put(Str.get("NaN"), Str.get(df.nan), this.info).put(Str.get("minus-sign"), Str.get(InspectStaticContext.token(df.minus)), this.info), this.info);
                }
                return map;
            }
        }
        throw QueryError.INSPECT_UNKNOWN_X.get(this.info, name);
    }

    @Override
    public BasicIter<?> iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    private static byte[] token(int ... cps) {
        TokenBuilder tb = new TokenBuilder(cps.length);
        for (int cp : cps) {
            tb.add(cp);
        }
        return tb.finish();
    }
}

