/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public class FnSubsequence
extends StandardFunc {
    private static final long[] ALL = new long[0];

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        long[] range = this.range(qc);
        if (range == null) {
            return Empty.ITER;
        }
        final Iter iter = this.exprs[0].iter(qc);
        if (range == ALL) {
            return iter;
        }
        long sz = iter.size();
        if (sz == 0L) {
            return Empty.ITER;
        }
        long s = range[0];
        long l = range[1];
        final long max = l == Long.MAX_VALUE ? l : s + l;
        final long start = Math.max(1L, s);
        final long end = Math.min(max, sz + 1L);
        Value value = iter.value();
        final long size = Math.max(0L, end - start);
        if (value != null) {
            return value.subSequence(start - 1L, size, qc).iter();
        }
        if (sz > 0L) {
            if (size == 0L) {
                return Empty.ITER;
            }
            return new Iter(){
                long c;
                {
                    this.c = start;
                }

                @Override
                public Item next() throws QueryException {
                    qc.checkStop();
                    return this.c < end ? iter.get(this.c++ - 1L) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return iter.get(start + i - 1L);
                }

                @Override
                public long size() {
                    return size;
                }
            };
        }
        return new Iter(){
            long c;

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(iter)) != null && ++this.c < max) {
                    if (this.c < start) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        long[] range = this.range(qc);
        if (range == null) {
            return Empty.SEQ;
        }
        Expr expr = this.exprs[0];
        if (range == ALL) {
            return expr.value(qc);
        }
        long st = range[0];
        long ln = range[1];
        Iter iter = expr.iter(qc);
        long size = iter.size();
        Value value = iter.value();
        if (value != null) {
            long start = Math.max(0L, st - 1L);
            long length = Math.min(size - start, ln + Math.min(0L, st - 1L));
            return length <= 0L ? Empty.SEQ : value.subSequence(start, length, qc);
        }
        if (size >= 0L) {
            long start = Math.max(0L, st - 1L);
            long length = Math.min(size - start, ln + Math.min(0L, st - 1L));
            if (start >= size || length <= 0L) {
                return Empty.SEQ;
            }
            if (start == 0L && length == size) {
                return iter.value(qc);
            }
            ValueBuilder vb = new ValueBuilder(qc);
            for (long i = 0L; i < length; ++i) {
                vb.add(iter.get(start + i));
            }
            return vb.value();
        }
        long max = ln == Long.MAX_VALUE ? ln : st + ln;
        ValueBuilder vb = new ValueBuilder(qc);
        int i = 1;
        while ((long)i < max && (item = qc.next(iter)) != null) {
            if ((long)i >= st) {
                vb.add(item);
            }
            ++i;
        }
        return vb.value();
    }

    private long[] range(QueryContext qc) throws QueryException {
        Object object;
        double st = this.toDouble(this.exprs[1], qc);
        if (Double.isNaN(st)) {
            return null;
        }
        long start = this.start(st);
        boolean min = start == Long.MIN_VALUE;
        long length = Long.MAX_VALUE;
        int el = this.exprs.length;
        if (el > 2) {
            double ln = this.toDouble(this.exprs[2], qc);
            if (Double.isNaN(ln)) {
                return null;
            }
            if (min && ln == Double.POSITIVE_INFINITY) {
                return null;
            }
            length = this.length(ln);
        }
        if (min) {
            object = length == Long.MAX_VALUE ? ALL : null;
        } else {
            long[] lArray = new long[2];
            lArray[0] = start;
            object = lArray;
            lArray[1] = this.length(start, length);
        }
        return object;
    }

    public long start(double value) {
        return StrictMath.round(value);
    }

    public long length(double value) {
        return StrictMath.round(value);
    }

    public long length(long start, long length) {
        return length;
    }

    @Override
    protected final Expr opt(CompileContext cc) throws QueryException {
        long[] range;
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        if (st.zero()) {
            return expr;
        }
        this.exprType.assign(st.type, st.occ.union(Occ.ZERO));
        if (this.exprs[1] instanceof Value && (this.exprs.length < 3 || this.exprs[2] instanceof Value) && (range = this.range(cc.qc)) != null) {
            if (range == ALL) {
                return expr;
            }
            return FileReadTextLines.rewrite(this, range[0], range[1], cc, this.info);
        }
        return this;
    }
}

