/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.math.BigInteger;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;

public final class BinShift
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        B64 b64 = this.toB64(this.exprs[0], qc, true);
        long by = this.toLong(this.exprs[1], qc);
        if (b64 == null) {
            return null;
        }
        if (by == 0L) {
            return b64;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        if (bl == 1 && by < 8L) {
            if (by > 0L) {
                return B64.get((byte)(bytes[0] << (int)by));
            }
            if (by > -8L) {
                return B64.get((byte)(bytes[0] >>> (int)(-by)));
            }
        }
        byte[] tmp = new byte[bl];
        int r = 0;
        if (by > 7L) {
            tmp = new BigInteger(bytes).shiftLeft((int)by).toByteArray();
            if (tmp.length != bl) {
                bytes = tmp;
                tmp = new byte[bl];
                System.arraycopy(bytes, bytes.length - bl, tmp, 0, bl);
            }
        } else if (by > 0L) {
            for (int i = bl - 1; i >= 0; --i) {
                byte b = bytes[i];
                tmp[i] = (byte)(b << (int)by | r);
                r = b >>> (int)(32L - by);
            }
        } else if (by > -8L) {
            by = -by;
            for (int i = 0; i < bl; ++i) {
                int b = bytes[i] & 0xFF;
                tmp[i] = (byte)(b >>> (int)by | r);
                r = b << (int)(32L - by);
            }
        } else {
            by = -by;
            BigInteger bi = new BigInteger(bytes);
            if (bi.signum() >= 0) {
                bi = bi.shiftRight((int)by);
            } else {
                BigInteger o = BigInteger.ONE.shiftLeft((bl << 3) + 1);
                BigInteger m = o.subtract(BigInteger.ONE).shiftRight((int)by + 1);
                bi = bi.subtract(o).shiftRight((int)by).and(m);
            }
            tmp = bi.toByteArray();
            int tl = tmp.length;
            if (tl != bl) {
                bytes = tmp;
                tmp = new byte[bl];
                System.arraycopy(bytes, 0, tmp, bl - tl, tl);
            }
        }
        return B64.get(tmp);
    }
}

