/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

public class ArchiveExtractTo
extends ArchiveFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        this.checkCreate(qc);
        Path path = this.toPath(0, qc);
        B64 archive = this.toB64(this.exprs[1], qc, false);
        TokenSet hs = this.entries(2, qc);
        try (ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);){
            while (in.more()) {
                ZipEntry ze = in.entry();
                String name = ze.getName();
                if (hs != null && hs.delete(Token.token(name)) == 0) continue;
                Path file = path.resolve(name);
                if (ze.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, in.read(), new OpenOption[0]);
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
        return null;
    }
}

