/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.B64;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public class ArchiveExtractBinary
extends ArchiveFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (byte[] bytes : this.extract(qc)) {
            vb.add(B64.get(bytes));
        }
        return vb.value();
    }

    final TokenList extract(QueryContext qc) throws QueryException {
        B64 archive = this.toB64(this.exprs[0], qc, false);
        TokenSet hs = this.entries(1, qc);
        TokenList tl = new TokenList();
        try (ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);){
            while (in.more()) {
                ZipEntry ze = in.entry();
                if (ze.isDirectory() || hs != null && hs.delete(Token.token(ze.getName())) == 0) continue;
                tl.add(in.read());
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
        return tl;
    }
}

