/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.PathCache;
import org.basex.query.expr.path.Step;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;

public abstract class AxisPath
extends Path {
    private final ThreadLocal<PathCache> caches = ThreadLocal.withInitial(PathCache::new);

    AxisPath(InputInfo info, Expr root, Expr ... steps) {
        super(info, root, steps);
    }

    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        PathCache cache = this.caches.get();
        switch (cache.state) {
            case INIT: {
                cache.state = !this.hasFreeVars() && !this.has(Flag.NDT) ? PathCache.State.ENABLED : PathCache.State.DISABLED;
                return this.iter(qc);
            }
            case ENABLED: {
                Value value = qc.focus.value;
                cache.initial = value instanceof DBNode ? ((DBNode)value).finish() : value;
                cache.state = PathCache.State.READY;
                break;
            }
            case READY: {
                if (cache.sameContext(qc.focus.value, this.root)) {
                    cache.result = this.nodeIter(qc).value(qc);
                    cache.state = PathCache.State.CACHED;
                    break;
                }
                cache.state = PathCache.State.DISABLED;
                break;
            }
            case CACHED: {
                if (cache.sameContext(qc.focus.value, this.root)) break;
                cache.result = null;
                cache.state = PathCache.State.DISABLED;
                break;
            }
        }
        Value result = cache.result;
        return result == null ? this.nodeIter(qc) : result.iter();
    }

    protected abstract NodeIter nodeIter(QueryContext var1) throws QueryException;

    public final Path invertPath(Expr rt, Step curr) {
        int s = this.steps.length - 1;
        Expr r = this.step((int)s).exprs.length == 0 ? rt : Filter.get(this.info, rt, this.step((int)s).exprs);
        ExprList stps = new ExprList();
        while (--s >= 0) {
            stps.add(Step.get(this.info, this.step((int)(s + 1)).axis.invert(), this.step((int)s).test, this.step((int)s).exprs));
        }
        stps.add(Step.get(this.info, this.step((int)(s + 1)).axis.invert(), curr.test, new Expr[0]));
        return (Path)Path.get(this.info, r, (Expr[])stps.finish());
    }

    public final Step step(int i) {
        return (Step)this.steps[i];
    }

    public final ParseExpr addPreds(Expr ... preds) {
        this.steps[this.steps.length - 1] = this.step(this.steps.length - 1).addPreds(preds);
        return this.copyType(AxisPath.get(this.info, this.root, this.steps));
    }

    @Override
    public final boolean iterable() {
        return true;
    }
}

